import {convertToSelectObject, convertToTextOptionSelectObject} from "./edm-select2";

const PREDEFINED_MACRO_SELECTOR = "span.edm-dropdown-menu";
const PREDEFINED_MACRO_MULTI_SELECTOR = "span.edm-dropdown-menu-multiple";
const NON_PREDEFINED_MACRO_SELECTOR = "span.edm-dropdown-menu-non-predefined";
const NON_PREDEFINED_MACRO_MULTI_SELECTOR = "span.edm-dropdown-menu-non-predefined-multiple";
export const NOT_EDM_LOAD_SELECTOR = ":not(.edm-load)";
const INVISIBLE_SEPARATOR = "\u2063";

//  ------------------------ HELPER METHODS --------------------------------------------
export const createDropdownMenu = function (spanElement, options, currentOption, isMulti) {
    AJS.$(spanElement).auiSelect2({
        dropdownAutoWidth: true,
        dropdownCssClass: 'edm-drop-container',
        minimumResultsForSearch: Infinity,
        allowClear: true,
        multiple: isMulti,
        formatNoMatches: () => "",
        formatSelection: isMulti ? formatSelectedOptionsMulti : formatSelectedOptions,
        data: convertToTextOptionSelectObject(options)
    });
    selectSelectedValue(spanElement, currentOption, isMulti);
};

// for compatibility with Table Filter Macro
const formatSelectedOptions = function (option) {
    return option.text;
};

const formatSelectedOptionsMulti = function (option) {
    return option.text + INVISIBLE_SEPARATOR;
};

export const selectSelectedValue = function (spanElement, currentOptionsArray, isMulti) {
    if (currentOptionsArray.length) {
        let data = {id: currentOptionsArray[0].id, text: currentOptionsArray[0].name};
        if (isMulti) {
            data = convertToTextOptionSelectObject(currentOptionsArray);
        }
        $(spanElement).select2("data", data);
    }
};

const disableDropdownElement = function (spanElement) {
    AJS.$(spanElement).prop("disabled", true);
};

const disableDropdownArray = function (array) {
    const dropdownMenuMultiple = [];
    const dropdownMenuSingle = [];
    const allOthers = [];
    array.forEach(function (element) {
        if (hasElementClass(element, "edm-dropdown-menu-multiple")) {
            dropdownMenuMultiple.push(element);
        } else if (hasElementClass(element, "edm-dropdown-menu-non-predefined-multiple")) {
            dropdownMenuMultiple.push(element);
        } else if (hasElementClass(element, "edm-dropdown-menu") || hasElementClass(element, "edm-dropdown-menu-non-predefined")) {
            dropdownMenuSingle.push(element);
        } else {
            allOthers.push(element);
        }
    });
    dropdownMenuMultiple.forEach(function (element) {
        replaceMultiDropdownWithPlainText(element);
    });
    dropdownMenuSingle.forEach((element) => {
        replaceSingleDropdowns(element);

    });
    allOthers.forEach(function (element) {
        disableDropdownElement(element);
    });
};

const replaceSingleDropdowns = (element) => {
    let text = "";
    if (!hasElementClass(element, "select2offscreen")) {
        const select2Choice = AJS.$(element).children(".select2-choice").children(".select2-chosen").toArray();
        if (select2Choice.length > 0) {
            text = AJS.$(select2Choice[0]).text();
        }
        replaceElementWithDiv(element, text);
    }

};

const replaceMultiDropdownWithPlainText = function (element) {
    let text = "";
    if (!hasElementClass(element, "select2-offscreen")) {
        const select2Choices = AJS.$(element).children(".select2-choices").children(".select2-search-choice").toArray();
        select2Choices.forEach(function (item) {
            const value = AJS.$(item).children("div").html();
            if (value != null && value.length > 0) {
                if (text.length > 0) {
                    text = text + ", ";
                }
                text = text + value;
            }
        });
        replaceElementWithDiv(element, text);
    }
};

const replaceElementWithDiv = (element, text) => {
    const div = document.createElement("div");
    div.innerHTML = text;
    div.style.lineHeight = "26px";
    div.style.display = "inline-block";
    AJS.$(element).replaceWith(div);
};

const hasElementClass = function (element, className) {
    return $(element).hasClass(className);
};

export const disableDropdownsForLock = () => {
    const pageBody = AJS.$("div[id=content]").toArray();
    pageBody.forEach(pageBody => {
        const disabledDropdowns = $(pageBody).find(".edm-referenced-dropdown, .edm-edit-disabled").toArray();
        disableDropdownArray(disabledDropdowns);
    });

    const detailsSummaryDiv = "div[data-macro-name='detailssummary']";
    const lockedInPagePropertyReport = "edm-lockedInPagePropertyReport-dropdown";

    const dropdowns = AJS.$(detailsSummaryDiv).toArray();
    dropdowns.forEach(dropdown => {
        const pagePropertyLocked = $(dropdown).find("." + lockedInPagePropertyReport).toArray();
        disableDropdownArray(pagePropertyLocked);
    });
};

export const initDropdownsPredefined = function (elementTarget) {
    setAllDropdownMenusPredefined(elementTarget);
    addChangeListenerToDropdownsPredefined(elementTarget);
    elementTarget.find(PREDEFINED_MACRO_SELECTOR).addClass("edm-load");
    elementTarget.find(PREDEFINED_MACRO_MULTI_SELECTOR).addClass("edm-load");
};

const setAllDropdownMenusPredefined = function (elementTarget) {
    elementTarget.find(PREDEFINED_MACRO_SELECTOR + NOT_EDM_LOAD_SELECTOR).each(function () {
        const options = JSON.parse(this.getAttribute("data-edm-optionsSetList"));
        const currentOption = JSON.parse(this.getAttribute("data-edm-chosenOptions"));
        createDropdownMenu(this, options, currentOption, false);
    });

    elementTarget.find(PREDEFINED_MACRO_MULTI_SELECTOR + NOT_EDM_LOAD_SELECTOR).each(function () {
        const options = JSON.parse(this.getAttribute("data-edm-optionsSetList"));
        const currentOption = JSON.parse(this.getAttribute("data-edm-chosenOptions"));
        createDropdownMenu(this, options, currentOption, true);
    });
};

// ------------------------ JQL ON CHANGE ---------------------------------
const saveOptionsTextDropdownPredefined = function (data) {
    Edm.Rest.updatePredefinedMacro(data);
};

const saveOptionTextDropdownNotPredefined = function (data) {
    Edm.Rest.updateNonPredefinedMacro(data);
};

const addChangeListenerToDropdownsPredefined = function (elementTarget) {
    elementTarget.find(`${PREDEFINED_MACRO_SELECTOR + NOT_EDM_LOAD_SELECTOR}, ${PREDEFINED_MACRO_MULTI_SELECTOR + NOT_EDM_LOAD_SELECTOR}`).on("change", function () {
        const optionsList = this.getAttribute("data-edm-optionsSetList");
        const pageId = this.getAttribute("data-pageId");
        const silentUpdate = this.getAttribute("data-silentUpdate");
        const data = {
            pageId: pageId,
            macroId: this.id,
            optionId: this.value,
            currentOptionValue: getCurrentOptionValueString(this.value, optionsList),
            silentUpdate: silentUpdate
        };
        saveOptionsTextDropdownPredefined(data);
    });
};

const getCurrentOptionValueString = function (currentOptionIdsString, optionsList) {
    let currentOptionValue = "";
    const parsedOptionsList = JSON.parse(optionsList);
    const chosenOptionIdsList = currentOptionIdsString.split(",");
    parsedOptionsList.forEach(function (option) {
        if (lookIfInuseAndAdToString(chosenOptionIdsList, option.id).length > 0) {
            currentOptionValue += option.name;
            currentOptionValue += ", ";
        }
    });
    if (currentOptionValue.length > 2) {
        currentOptionValue = currentOptionValue.substring(0, currentOptionValue.length - 2);
    }
    return currentOptionValue;
};

const lookIfInuseAndAdToString = function (chosenOptionList, chosenOptionId) {
    for (let i = 0; i < chosenOptionList.length; i++) {
        if (chosenOptionId.trim() === chosenOptionList[i].trim()) {
            return chosenOptionId.trim();
        }
    }
    return "";
};

// -------------------------- NON_PREDEFINED----------------------------
const selectNonPredefinedSelectedValue = function (spanElement, currentOption) {
    if (currentOption !== "") {
        AJS.$(spanElement).val(currentOption).trigger("change");
    }
};

export const createDropdownMenuNonPredefined = function (spanElement, options, currentOption, isMulti) {
    AJS.$(spanElement).auiSelect2({
        dropdownAutoWidth: true,
        dropdownCssClass: 'edm-drop-container',
        minimumResultsForSearch: Infinity,
        multiple: isMulti,
        allowClear: true,
        formatNoMatches: () => "",
        formatSelection: isMulti ? formatSelectedOptionsMulti : formatSelectedOptions,
        data: convertToSelectObject(options)
    });
    selectNonPredefinedSelectedValue(spanElement, currentOption);
};

// -------------------------- GET MULTI DROPDOWN PICKED OPTIONS -------------------------
const getOptionsMultiple = function (el) {
    const options = el.select2("data");
    let optionsString = "";
    options.forEach(function (entry) {
        optionsString += entry.text.trim() + ",";
    });

    if (optionsString.slice(-1) === ",") {
        optionsString = optionsString.slice(0, -1);
    }
    return optionsString;
};

export const initDropdownsNonPredefined = function (elementTarget) {
    setAllDropdownMenusNonPredefined(elementTarget);
    addChangeListenerToDropdownsNonPredefined(elementTarget);
    elementTarget.find(NON_PREDEFINED_MACRO_SELECTOR).addClass("edm-load");
    elementTarget.find(NON_PREDEFINED_MACRO_MULTI_SELECTOR).addClass("edm-load");
};

const setAllDropdownMenusNonPredefined = function (elementTarget) {
    elementTarget.find(NON_PREDEFINED_MACRO_SELECTOR + NOT_EDM_LOAD_SELECTOR).each(function () {
        const options = this.getAttribute("data-edm-options").split(",");
        const currentOption = this.getAttribute("data-edm-currentOption");
        createDropdownMenuNonPredefined(this, options, currentOption, false);
    });

    elementTarget.find(NON_PREDEFINED_MACRO_MULTI_SELECTOR + NOT_EDM_LOAD_SELECTOR).each(function () {
        const options = this.getAttribute("data-edm-options").split(",");
        const currentOption = this.getAttribute("data-edm-currentOption");
        createDropdownMenuNonPredefined(this, options, currentOption, true);
    });
};

const addChangeListenerToDropdownsNonPredefined = function (elementTarget) {
    elementTarget.find(NON_PREDEFINED_MACRO_SELECTOR + NOT_EDM_LOAD_SELECTOR).on("change", function () {
        const pageId = this.getAttribute("data-pageId");
        const silentUpdate = this.getAttribute("data-silentUpdate");
        const data = {
            pageId: pageId,
            macroId: this.id,
            currentOption: this.value,
            silentUpdate: silentUpdate
        };
        saveOptionTextDropdownNotPredefined(data);
    });
    elementTarget.find(NON_PREDEFINED_MACRO_MULTI_SELECTOR + NOT_EDM_LOAD_SELECTOR).on("change", function () {
        const pageId = this.getAttribute("data-pageId");
        const silentUpdate = this.getAttribute("data-silentUpdate");
        const data = {
            pageId: pageId,
            macroId: this.id,
            currentOption: getOptionsMultiple(AJS.$(this)),
            silentUpdate: silentUpdate
        };
        saveOptionTextDropdownNotPredefined(data);
    });
};
