/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.taskUtils.tasks;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.Page;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.fix.DuplicationAnalyzer;
import eps.focuspro.fix.DuplicationFinder;
import eps.focuspro.fix.ResolveInstantiation;
import eps.focuspro.fix.onpage.PageUpdater;
import eps.focuspro.search.MappingExecuter;
import eps.focuspro.taskUtils.core.EdmLongRunningTask;
import eps.focuspro.taskUtils.core.ResponseData;
import eps.focuspro.taskUtils.core.SuccessEventData;
import eps.focuspro.taskUtils.core.TaskManager;
import eps.focuspro.taskUtils.helper.PageUrlMappingProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicationResolveTask
extends EdmLongRunningTask {
    private final Logger log = LoggerFactory.getLogger(DuplicationResolveTask.class);
    private final TaskManager taskManager;
    private final DuplicationFinder duplicationFinder;
    private final MappingExecuter mappingExecuter;
    private final SetEntityAccessor setEntityAccessor;
    private final PageUpdater pageUpdater;
    private final DuplicationAnalyzer duplicationAnalyzer;
    private final PageUrlMappingProvider pageUrlMappingProvider;
    private final TransactionTemplate transactionTemplate;

    public DuplicationResolveTask(TaskManager taskManager, DuplicationFinder duplicationFinder, MappingExecuter mappingExecuter, SetEntityAccessor setEntityAccessor, PageUpdater pageUpdater, DuplicationAnalyzer duplicationAnalyzer, ActiveObjects ao, PageUrlMappingProvider pageUrlMappingProvider, TransactionTemplate transactionTemplate) {
        this.taskManager = taskManager;
        this.duplicationFinder = duplicationFinder;
        this.mappingExecuter = mappingExecuter;
        this.setEntityAccessor = setEntityAccessor;
        this.pageUpdater = pageUpdater;
        this.duplicationAnalyzer = duplicationAnalyzer;
        ActiveObjects ao1 = Objects.requireNonNull(ao);
        this.pageUrlMappingProvider = pageUrlMappingProvider;
        this.transactionTemplate = transactionTemplate;
    }

    protected void runInternal() {
        this.progress.setPercentage(0, 100);
        this.progress.setStatus("Looking for duplicated set");
        List<DropdownSet<TextOption>> textSets = this.duplicationFinder.getFirstDuplicatedTextSetList("");
        if (textSets != null && !textSets.isEmpty()) {
            this.resolveTextSet(textSets);
        } else {
            List<DropdownSet<LozengeOption>> statusSets = this.duplicationFinder.getFirstDuplicatedStatusSetList("");
            if (statusSets != null && !statusSets.isEmpty()) {
                this.resolveStatusSet(statusSets);
            } else {
                this.completeProgress(0, "none");
                this.taskManager.add(this.getResponseId(), new ResponseData(new SuccessEventData("No duplicated sets found", new ArrayList<Map<String, String>>())));
            }
        }
    }

    private void resolveTextSet(List<DropdownSet<TextOption>> sets) {
        String setName = sets.get(0).getName();
        this.log.warn("Starting to resolve duplication of textSet with name: " + setName);
        this.progress.setStatus("Resolving text set with name: " + setName);
        ResolveInstantiation updateInstantiation = this.duplicationAnalyzer.createUpdateInstantiation(sets);
        this.deleteAndSaveTextSets(updateInstantiation.getUnusedSets(), updateInstantiation.getMainSet());
        int total = this.mappingExecuter.getTotal(updateInstantiation.getAffectedPagesMapping());
        this.progress.setTotalObjects(total + 2);
        this.progress.setCurrentCount(0);
        this.log.warn("Found a total of " + total + " pages, that had the Text setName " + setName + " and need to be updated");
        List<Long> editedPages = this.mappingExecuter.handlePages(updateInstantiation.getAffectedPagesMapping(), page -> {
            this.progress.setCurrentCount(this.progress.getCurrentCount() + 1);
            return this.pageUpdater.updateTextMacrosOnPage((Page)page, updateInstantiation.getSetMapping(), updateInstantiation.getOptionsMapping());
        });
        this.taskManager.add(this.getResponseId(), new ResponseData(new SuccessEventData("Text set: " + setName + " resolved, " + editedPages.size() + " pages updated", this.pageUrlMappingProvider.getPageMappings(editedPages))));
        this.completeProgress(editedPages.size(), setName);
    }

    private void resolveStatusSet(List<DropdownSet<LozengeOption>> sets) {
        this.log.warn("Starting to resolve duplication of statusSet with name: " + sets.get(0).getName());
        String setName = sets.get(0).getName();
        this.log.warn("Starting to resolve duplication of status with name: " + setName);
        this.progress.setStatus("Resolving status set with name: " + setName);
        ResolveInstantiation updateInstantiation = this.duplicationAnalyzer.createUpdateInstantiation(sets);
        this.deleteAndSaveStatusSets(sets, updateInstantiation.getMainSet());
        int total = this.mappingExecuter.getTotal(updateInstantiation.getAffectedPagesMapping());
        this.progress.setTotalObjects(total + 2);
        this.progress.setCurrentCount(0);
        this.progress.setStatus("Resolving " + total + " pages with Status setname: " + setName);
        List<Long> editedPages = this.mappingExecuter.handlePages(updateInstantiation.getAffectedPagesMapping(), page -> {
            int currentCount = this.progress.getCurrentCount();
            this.log.info("Currently Modifying page number: " + currentCount);
            this.progress.setCurrentCount(currentCount + 1);
            return this.pageUpdater.updateStatusMacrosOnPage((Page)page, updateInstantiation.getSetMapping(), updateInstantiation.getOptionsMapping());
        });
        this.completeProgress(editedPages.size(), setName);
        this.taskManager.add(this.getResponseId(), new ResponseData(new SuccessEventData("Status set: " + setName + " resolved, " + editedPages.size() + " pages updated", this.pageUrlMappingProvider.getPageMappings(editedPages))));
    }

    private void completeProgress(int pagesUpdated, String setName) {
        this.progress.setStatus("Updated a total of " + pagesUpdated + " pages with macros with setname: " + setName);
        this.progress.setPercentage(100);
    }

    private void deleteAndSaveTextSets(List<DropdownSet<TextOption>> list, DropdownSet<TextOption> main) {
        this.transactionTemplate.execute(() -> {
            for (DropdownSet set : list) {
                this.setEntityAccessor.deleteTextSetEntity(set.getId());
            }
            this.setEntityAccessor.saveTextSetUnTransactional(main, "");
            return null;
        });
    }

    private void deleteAndSaveStatusSets(List<DropdownSet<LozengeOption>> list, DropdownSet<LozengeOption> main) {
        this.transactionTemplate.execute(() -> {
            for (DropdownSet set : list) {
                this.setEntityAccessor.deleteLozengeSetEntity(set.getId());
            }
            this.setEntityAccessor.saveLozengeSetUnTransactional(main, "");
            return null;
        });
    }

    public String getName() {
        return "EDM Duplication Resolve Process";
    }
}

