/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.search.core;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageConverter {
    private final PageManager pageManager;
    private static final Logger log = LoggerFactory.getLogger(PageConverter.class);

    public PageConverter(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public Page convertToPage(SearchResult searchResult) {
        String spaceKey = searchResult.getSpaceKey();
        String title = searchResult.getDisplayTitle();
        return this.convertToPage(spaceKey, title);
    }

    public Page convertToPage(String spaceKey, String title) {
        Page page = null;
        try {
            page = this.pageManager.getPage(spaceKey, title);
        }
        catch (Exception e) {
            log.warn("There was an exception when trying to get the page from a searchResult");
        }
        return page;
    }
}

