/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.search;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.core.bean.EntityObject;
import eps.focuspro.search.core.FieldValueProvider;
import eps.focuspro.search.core.PageConverter;
import eps.focuspro.search.core.SearchResultProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageSearcher {
    private final SearchResultProvider searchResultProvider;
    private static final Logger log = LoggerFactory.getLogger(PageSearcher.class);
    private final FieldValueProvider fieldValueProvider;
    private final PageConverter pageConverter;
    private final PageManager pageManager;

    public PageSearcher(SearchResultProvider searchResultProvider, PageManager pageManager, FieldValueProvider fieldValueProvider, PageConverter pageConverter) {
        this.searchResultProvider = searchResultProvider;
        this.fieldValueProvider = fieldValueProvider;
        this.pageConverter = pageConverter;
        this.pageManager = pageManager;
    }

    public List<Page> getPagesForMacroName(String ... macroNames) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        for (String macroName : macroNames) {
            searchResults.addAll(this.searchResultProvider.searchMacroName(macroName));
        }
        return this.convertSearchResults(searchResults);
    }

    public Map<String, Set<String>> getPagesMappingForMacroName(String ... macroNames) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String macroName : macroNames) {
            List<SearchResult> searchResults = this.searchResultProvider.searchMacroName(macroName);
            this.addSearchResultsToMap(searchResults, map);
        }
        return map;
    }

    public Map<String, Set<String>> getPagesMappingForSetIds(Set<String> setIds) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String setId : setIds) {
            List<SearchResult> searchResults = this.getSearchResultsForFieldValueMapping(setId);
            this.addSearchResultsToMap(searchResults, map);
        }
        return map;
    }

    public int getSearchResultCountForSetId(String setId) {
        return this.getSearchResultsForFieldValueMapping(setId).size();
    }

    public List<Page> getPagesForFieldName(String ... fieldNames) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        for (String fieldName : fieldNames) {
            searchResults.addAll(this.searchResultProvider.searchFieldName(fieldName));
        }
        return this.convertSearchResults(searchResults);
    }

    public List<Page> getPagesForSetId(String setId) {
        List<SearchResult> filtered = this.getSearchResultsForFieldValueMapping(setId);
        return this.convertSearchResults(filtered);
    }

    private void addSearchResultsToMap(List<SearchResult> searchResults, Map<String, Set<String>> map) {
        for (SearchResult searchResult : searchResults) {
            String spaceKey = searchResult.getSpaceKey();
            String title = searchResult.getDisplayTitle();
            if (!StringUtils.isNotBlank((CharSequence)title) || !StringUtils.isNotBlank((CharSequence)spaceKey)) continue;
            Set<String> pageTitles = map.get(spaceKey);
            if (pageTitles != null) {
                pageTitles.add(title);
                continue;
            }
            pageTitles = new HashSet<String>();
            pageTitles.add(title);
            map.put(spaceKey, pageTitles);
        }
    }

    private List<SearchResult> getSearchResultsForFieldValueMapping(String fieldValue) {
        List<SearchResult> searchResults = this.searchResultProvider.searchFieldName("EdmSetId");
        ArrayList<SearchResult> filtered = new ArrayList<SearchResult>();
        for (SearchResult searchResult : searchResults) {
            if (!this.fieldValueProvider.doesSearchResultContainFieldValue(searchResult, fieldValue, "EdmSetId")) continue;
            filtered.add(searchResult);
        }
        return filtered;
    }

    private List<Page> makePagesUnique(List<Page> pages) {
        return pages.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Page>(Comparator.comparingLong(EntityObject::getId))), ArrayList::new));
    }

    private List<Page> convertSearchResults(List<SearchResult> searchResults) {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (SearchResult searchResult : searchResults) {
            Page page = this.pageConverter.convertToPage(searchResult);
            if (page == null) continue;
            pages.add(page);
        }
        return this.makePagesUnique(pages);
    }
}

