/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.helper;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.ConversionContextCreator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroLogger {
    private static final Logger generalLogger = LoggerFactory.getLogger(MacroLogger.class);
    public static final int MAX_LOG_MESSAGE_SIZE = 8000;
    private final PageManager pageManager;
    private final XhtmlContent xhtmlContent;

    public MacroLogger(PageManager pageManager, XhtmlContent xhtmlContent) {
        this.pageManager = pageManager;
        this.xhtmlContent = xhtmlContent;
    }

    public void logMacrosOfPage(long pageId, String invocationName) {
        try {
            Page page = this.pageManager.getPage(pageId);
            if (page == null) {
                generalLogger.warn("Page with id '{}' not found", (Object)pageId);
                return;
            }
            Logger log = LoggerFactory.getLogger((String)("eps.focuspro.edm.debug." + page.getSpaceKey()));
            if (log.isDebugEnabled()) {
                String logMessage = this.createLogMessage(page, invocationName);
                log.debug(logMessage);
            }
        }
        catch (Exception e) {
            generalLogger.warn("Exception while creating logs for page: " + pageId, (Throwable)e);
        }
    }

    private String createLogMessage(Page page, String invocationName) throws XhtmlException {
        StringBuilder sb = new StringBuilder();
        sb.append("EASY DROPDOWN MENU ::: ").append(invocationName).append(" ::: ");
        sb.append("page='").append(page.getDisplayTitle()).append(".v").append(page.getVersion()).append(":").append(page.getSpaceKey()).append("(").append(page.getId()).append(")' ::: ");
        sb.append("macros=[");
        this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), new ConversionContextCreator().createConversionContext((ContentEntityObject)page), macroDefinition -> {
            if (sb.length() >= 8000) {
                return;
            }
            if (this.isEdmMacro(macroDefinition.getName())) {
                sb.append("{name:'").append(macroDefinition.getName()).append("',macroId:'").append(macroDefinition.getMacroIdentifier().map(MacroId::getId).orElse("NULL")).append("',");
                if (this.isNonPredefined(macroDefinition.getName())) {
                    sb.append("currentOption:'").append(macroDefinition.getParameter("currentOption")).append("'");
                } else {
                    sb.append("setId:'").append(macroDefinition.getParameter("set-id")).append("',optionId:'").append(macroDefinition.getParameter("option-id")).append("',");
                    sb.append("optionValue:'").append(macroDefinition.getParameter("current-option-value")).append("'");
                }
                sb.append("},");
            }
        });
        if (sb.length() >= 8000) {
            generalLogger.warn("Debug log message for page {} in debug mode exceeded custom EDM limit of {} characters - output will not be complete", (Object)page.getId(), (Object)8000);
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean isNonPredefined(String macroName) {
        return macroName.equals("easy-dropdown-menu");
    }

    private boolean isEdmMacro(String macroName) {
        return macroName != null && macroName.startsWith("easy-dropdown-menu");
    }
}

