/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.gson.Gson;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Option;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.rest.dtos.DataMigrationDto;
import eps.focuspro.rest.dtos.SpaceKeysDto;
import eps.focuspro.rest.helper.DataMigrationHandler;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/data-migration")
public class RestDataMigration {
    private final ResourcesRunner resourcesRunner;
    private final DataMigrationHandler dataMigrationHandler;
    private final TransactionTemplate transactionTemplate;
    private final SetEntityAccessor setEntityAccessor;

    @Inject
    public RestDataMigration(ResourcesRunner resourcesRunner, DataMigrationHandler dataMigrationHandler, TransactionTemplate transactionTemplate, SetEntityAccessor setEntityAccessor) {
        this.resourcesRunner = resourcesRunner;
        this.dataMigrationHandler = dataMigrationHandler;
        this.transactionTemplate = transactionTemplate;
        this.setEntityAccessor = setEntityAccessor;
    }

    @POST
    @Path(value="/get-data-json")
    public Response getDataJson(SpaceKeysDto spaceKeysDto) {
        ArrayList edmSetConfigurations = new ArrayList();
        String[] spaceKeys = spaceKeysDto.spaceKeys;
        return this.resourcesRunner.run(() -> {
            for (String spaceKey : spaceKeys) {
                edmSetConfigurations.add(this.dataMigrationHandler.getDataMigrationDto(spaceKey));
            }
            return Response.ok((Object)new Gson().toJson((Object)edmSetConfigurations), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withGlobalAdminRights().withPluginLicense().build());
    }

    @PUT
    @Path(value="/save-data-json")
    public Response saveDataJson(DataMigrationDto[] dataMigrationDtoArray) {
        return this.resourcesRunner.run(() -> (Response)this.transactionTemplate.execute(() -> {
            for (DataMigrationDto dataMigrationDto : dataMigrationDtoArray) {
                DropdownSet<Option> setToSave;
                for (DropdownSet<TextOption> dropdownSet : dataMigrationDto.textSets) {
                    setToSave = this.dataMigrationHandler.mergeSets(dropdownSet, this.setEntityAccessor.getTextSet(dropdownSet.getId()));
                    this.setEntityAccessor.saveTextSetUnTransactional(setToSave, dataMigrationDto.spaceKey);
                }
                for (DropdownSet<Option> dropdownSet : dataMigrationDto.lozengeSets) {
                    setToSave = this.dataMigrationHandler.mergeSets(dropdownSet, this.setEntityAccessor.getLozengeSet(dropdownSet.getId()));
                    this.setEntityAccessor.saveLozengeSetUnTransactional(setToSave, dataMigrationDto.spaceKey);
                }
                this.dataMigrationHandler.mergeAndSavePermittedGroups(dataMigrationDto.spaceKey, dataMigrationDto.permittedGroups);
            }
            return Response.ok().build();
        }), new ResourceContextBuilder().withGlobalAdminRights().withPluginLicense().build());
    }
}

