/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration.cloudMigration;

import com.atlassian.migration.app.tracker.AbstractCloudMigrationListener;
import com.atlassian.migration.app.tracker.AccessScope;
import com.atlassian.migration.app.tracker.BoundCloudMigrationGateway;
import com.atlassian.migration.app.tracker.CloudMigrationAccessor;
import com.atlassian.migration.app.tracker.CloudMigrationListenerV1;
import com.atlassian.migration.app.tracker.MigrationDetailsV1;
import com.atlassian.migration.app.tracker.PaginatedContainers;
import com.atlassian.migration.app.tracker.container.ConfluenceSpaceContainerV1;
import com.atlassian.migration.app.tracker.container.ContainerType;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.gson.Gson;
import eps.focuspro.migration.cloudMigration.LocalCloudMigrationAccessor;
import eps.focuspro.rest.dtos.DataMigrationDto;
import eps.focuspro.rest.helper.DataMigrationHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AppDataMigrator
implements CloudMigrationListenerV1,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AppDataMigrator.class);
    private final CloudMigrationAccessor accessor;
    private final TransactionTemplate transactionTemplate;
    private final DataMigrationHandler dataMigrationHandler;

    public AppDataMigrator(LocalCloudMigrationAccessor localCloudMigrationAccessor, TransactionTemplate transactionTemplate, DataMigrationHandler dataMigrationHandler) {
        this.accessor = localCloudMigrationAccessor.getCloudMigrationAccessor();
        this.transactionTemplate = transactionTemplate;
        this.dataMigrationHandler = dataMigrationHandler;
    }

    public void onRegistrationAccepted() {
        log.debug("Nice! The migration listener is ready to take migrations events");
    }

    public void onStartAppMigration(String transferId, MigrationDetailsV1 migrationDetailsV1) {
        BoundCloudMigrationGateway gateway = this.accessor.getCloudMigrationGateway();
        ArrayList<ConfluenceSpaceContainerV1> confluenceSpaceContainersV1 = new ArrayList<ConfluenceSpaceContainerV1>();
        ArrayList<DataMigrationDto> edmSetConfigurations = new ArrayList<DataMigrationDto>();
        this.retrieveMigratedSpaceContainers(gateway, transferId, confluenceSpaceContainersV1);
        this.prepareEdmSetConfigurations(confluenceSpaceContainersV1, edmSetConfigurations);
        this.uploadAppData(gateway, transferId, edmSetConfigurations);
    }

    public void onRegistrarRemoved() {
        log.info("The listener is no longer active");
    }

    public String getCloudAppKey() {
        return "eps.focuspro.EasyDropdownMenu";
    }

    public String getServerAppKey() {
        return "eps.focuspro.EasyDropdownMenu";
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_UGC, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }

    public void afterPropertiesSet() {
        this.accessor.registerListener((AbstractCloudMigrationListener)this);
    }

    public void destroy() {
        this.accessor.deregisterListener((AbstractCloudMigrationListener)this);
    }

    private void retrieveMigratedSpaceContainers(BoundCloudMigrationGateway gateway, String transferId, List<ConfluenceSpaceContainerV1> confluenceSpaceContainersV1) {
        try {
            boolean pageSize = true;
            PaginatedContainers paginatedSpaceContainers = gateway.getPaginatedContainers(transferId, ContainerType.ConfluenceSpace, 1);
            while (paginatedSpaceContainers.next()) {
                confluenceSpaceContainersV1.add((ConfluenceSpaceContainerV1)paginatedSpaceContainers.getContainers().get(0));
            }
        }
        catch (Exception e) {
            log.error("Error while retrieving space keys for migration", (Throwable)e);
        }
    }

    private void prepareEdmSetConfigurations(List<ConfluenceSpaceContainerV1> confluenceSpaceContainersV1, List<DataMigrationDto> edmSetConfigurations) {
        try {
            this.transactionTemplate.execute(() -> {
                edmSetConfigurations.add(this.dataMigrationHandler.getDataMigrationDto(""));
                for (ConfluenceSpaceContainerV1 confluenceSpaceContainerV1 : confluenceSpaceContainersV1) {
                    edmSetConfigurations.add(this.dataMigrationHandler.getDataMigrationDto(confluenceSpaceContainerV1.getKey()));
                }
                return true;
            });
        }
        catch (Exception e) {
            log.error("Error while retrieving and preparing edm sets for migration", (Throwable)e);
        }
    }

    private void uploadAppData(BoundCloudMigrationGateway gateway, String transferId, List<DataMigrationDto> edmSetConfigurations) {
        try {
            OutputStream outputStream = gateway.createAppData(transferId, "edm-set-configurations");
            outputStream.write(new Gson().toJson(edmSetConfigurations).getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            log.error("Error while uploading edm app data to the cloud storage", (Throwable)e);
        }
    }
}

