/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.configui.DatabaseSettingsManager;
import eps.focuspro.configui.spaceconfig.SpaceSettings;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.daos.Version1MappingsDao;
import eps.focuspro.migration.newSetCreator.LozengeSetUpdater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class LozengeSettingsConverter {
    private final SpaceSettings spaceSettings;
    private DatabaseSettingsManager databaseSettingsManager;
    private LozengeSetUpdater lozengeSetUpdater;
    private Version1MappingsDao version1MappingsDao;
    private SetEntityAccessor setEntityAccessor;
    public static final String EDM_STATUS_SPACE_SET_MAPPING_KEY = "edm-status-space-set-mapping-key";
    public static final String EDM_STATUS_GLOBAL_SET_MAPPING_KEY = "edm-status-global-set-mapping-key";
    public static final String EDM_STATUS_SPACE_OPTIONS_MAPPING_KEY = "edm-status-space-options-mapping-key";
    public static final String EDM_STATUS_GLOBAL_OPTIONS_MAPPING_KEY = "edm-status-global-options-mapping-key";
    public final Supplier<Map<String, Map<String, String>>> createGlobalSettingsSupplier = () -> this.databaseSettingsManager.getDbSettings().getConfigStatusOptions();
    public final Function<Map<String, Map<String, String>>, List<DropdownSet<LozengeOption>>> createNewSets = oldLozengeSets -> {
        ArrayList sets = new ArrayList();
        oldLozengeSets.forEach((key, value) -> sets.add(this.lozengeSetUpdater.createNewSet((String)key, (Map<String, String>)value)));
        return sets;
    };
    public final Function<List<DropdownSet<LozengeOption>>, Map<String, String>> setMappingFunction = dropdownSetList -> {
        HashMap<String, String> setMapping = new HashMap<String, String>();
        for (DropdownSet dropdownSet : dropdownSetList) {
            setMapping.put(dropdownSet.getName(), dropdownSet.getId());
        }
        return setMapping;
    };
    public final Function<List<DropdownSet<LozengeOption>>, Map<String, Map<String, String>>> statusOptionsMapping = dropdownSetList -> {
        HashMap<String, Map<String, String>> optionsMapping = new HashMap<String, Map<String, String>>();
        for (DropdownSet dropdownSet : dropdownSetList) {
            optionsMapping.put(dropdownSet.getId(), this.getSingleOptionsMapping(dropdownSet));
        }
        return optionsMapping;
    };
    public final Consumer<List<DropdownSet<LozengeOption>>> globalSetSaver = dropdownSetList -> {
        for (DropdownSet dropdownSet : dropdownSetList) {
            this.setEntityAccessor.saveLozengeSetUnTransactional(dropdownSet, "");
        }
    };
    public final BiConsumer<Map<String, String>, Map<String, Map<String, String>>> globalMappingSaver = (setMapping, optionsMapping) -> {
        this.version1MappingsDao.saveSetIdMappings((Map<String, String>)setMapping, "");
        this.version1MappingsDao.saveOptionIdMappings((Map<String, Map<String, String>>)optionsMapping);
    };

    public LozengeSettingsConverter(SpaceSettings spaceSettings, DatabaseSettingsManager databaseSettingsManager, SetEntityAccessor setEntityAccessor, Version1MappingsDao version1MappingsDao) {
        this.spaceSettings = spaceSettings;
        this.databaseSettingsManager = databaseSettingsManager;
        this.lozengeSetUpdater = new LozengeSetUpdater();
        this.version1MappingsDao = version1MappingsDao;
        this.setEntityAccessor = setEntityAccessor;
    }

    Supplier<Map<String, Map<String, String>>> createSpaceSettingsSupplier(String spaceKey) {
        return () -> this.spaceSettings.loadLozenge(spaceKey);
    }

    public Consumer<List<DropdownSet<LozengeOption>>> spaceSetSaver(String spaceKey) {
        return dropdownSetList -> {
            for (DropdownSet dropdownSet : dropdownSetList) {
                this.setEntityAccessor.saveLozengeSetUnTransactional(dropdownSet, spaceKey);
            }
        };
    }

    public BiConsumer<Map<String, String>, Map<String, Map<String, String>>> spaceMappingSaver(String spaceKey) {
        return (setMapping, optionsMapping) -> {
            this.version1MappingsDao.saveSetIdMappings((Map<String, String>)setMapping, spaceKey);
            this.version1MappingsDao.saveOptionIdMappings((Map<String, Map<String, String>>)optionsMapping);
        };
    }

    private Map<String, String> getSingleOptionsMapping(DropdownSet<LozengeOption> dropdownSet) {
        HashMap<String, String> singleOptionsMapping = new HashMap<String, String>();
        List<LozengeOption> optionsList = dropdownSet.getOptionsList();
        for (LozengeOption lozengeOption : optionsList) {
            singleOptionsMapping.put(lozengeOption.getColor(), lozengeOption.getId());
        }
        return singleOptionsMapping;
    }
}

