/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.database.DropdownSetLozengeDatabase;
import eps.focuspro.database.DropdownSetTextDatabase;
import eps.focuspro.database.HistoryDatabase;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.SetHistoryAccesor;
import eps.focuspro.history.historyAccessors.HistoryAccessor;
import eps.focuspro.history.historyObjects.SetHistory;
import eps.focuspro.migration.StatusMigrationTaskInvoker;
import eps.focuspro.migration.reflectors.LozengeReflector;
import eps.focuspro.migration.reflectors.TextReflector;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveObjectsMigrator {
    private final LozengeReflector lozengeReflector = new LozengeReflector();
    private final TextReflector textReflector = new TextReflector();
    private final DropdownSetLozengeDatabase dropdownSetLozengeDatabase;
    private final DropdownSetTextDatabase dropdownSetTextDatabase;
    private final SetEntityAccessor setEntityAccessor;
    private final HistoryAccessor oldLozengeHistoryAccesor;
    private final HistoryAccessor oldTextHistoryAccesor;
    private final SetHistoryAccesor setHistoryAccesor;
    private static final Logger log = LoggerFactory.getLogger(StatusMigrationTaskInvoker.class);

    public ActiveObjectsMigrator(HistoryDatabase historyDatabase, DropdownSetLozengeDatabase dropdownSetLozengeDatabase, DropdownSetTextDatabase dropdownSetTextDatabase, SetEntityAccessor setEntityAccessor, SetHistoryAccesor setHistoryAccesor) {
        this.dropdownSetLozengeDatabase = dropdownSetLozengeDatabase;
        this.dropdownSetTextDatabase = dropdownSetTextDatabase;
        this.setEntityAccessor = setEntityAccessor;
        this.oldLozengeHistoryAccesor = new HistoryAccessor(historyDatabase);
        this.oldTextHistoryAccesor = new HistoryAccessor(historyDatabase);
        this.setHistoryAccesor = setHistoryAccesor;
        this.oldLozengeHistoryAccesor.setDatabaseKeys("status-set-history-list-admin2", "status-set-history-list-space2");
        this.oldTextHistoryAccesor.setDatabaseKeys("text-set-history-list-admin", "text-set-history-list-space");
    }

    public void migrateGlobalSets() {
        if (this.setEntityAccessor.areThereNoTextSetsPresent("")) {
            this.migrateGlobalTextSets();
        } else {
            log.info("Didn't migrate global text sets from bandana as there were already sets present!");
        }
        if (this.setEntityAccessor.areThereNoStatusSetsPresent("")) {
            this.migrateGlobalLozenges();
        } else {
            log.info("Didn't migrate global status sets from bandana as there were already sets present!");
        }
    }

    public void migrateSetsForSpace(String spaceKey) {
        if (this.setEntityAccessor.areThereNoTextSetsPresent(spaceKey)) {
            this.migrateTextSetsForSpace(spaceKey);
        } else {
            log.info("Didn't migrate space text sets from bandana as there were already sets present!");
        }
        if (this.setEntityAccessor.areThereNoStatusSetsPresent(spaceKey)) {
            this.migrateStatusSetsForSpace(spaceKey);
        } else {
            log.info("Didn't migrate space status sets from bandana as there were already sets present!");
        }
    }

    private void migrateGlobalTextSets() {
        List<DropdownSet<TextOption>> list = this.dropdownSetTextDatabase.getGlobalDropdownSets();
        List<DropdownSet<TextOption>> dropdownSets = this.textReflector.reflectTextDropdowns(list);
        this.saveTextSetsInAo(dropdownSets, "");
        this.saveGlobalTextSetHistoryInAo();
    }

    private void migrateGlobalLozenges() {
        List<DropdownSet<LozengeOption>> list = this.dropdownSetLozengeDatabase.getGlobalDropdownSets();
        List<DropdownSet<LozengeOption>> dropdownSets = this.lozengeReflector.reflectLozengeDropdownSets(list);
        this.saveLozengeSetsInAo(dropdownSets, "");
        this.saveGlobalLozengeSetHistoryInAo();
    }

    private void migrateStatusSetsForSpace(String spaceKey) {
        List<DropdownSet<LozengeOption>> list = this.dropdownSetLozengeDatabase.getSpaceDropdownSets(spaceKey);
        List<DropdownSet<LozengeOption>> dropdownSets = this.lozengeReflector.reflectLozengeDropdownSets(list);
        this.saveLozengeSetsInAo(dropdownSets, spaceKey);
        this.saveSpaceLozengeSetHistoryInAo(spaceKey);
    }

    private void migrateTextSetsForSpace(String spaceKey) {
        List<DropdownSet<TextOption>> list = this.dropdownSetTextDatabase.getSpaceDropdownSets(spaceKey);
        List<DropdownSet<TextOption>> dropdownSets = this.textReflector.reflectTextDropdowns(list);
        this.saveTextSetsInAo(dropdownSets, spaceKey);
        this.saveSpaceTextSetHistoryInAo(spaceKey);
    }

    private void saveLozengeSetsInAo(List<DropdownSet<LozengeOption>> list, String spaceKey) {
        if (!list.isEmpty()) {
            for (DropdownSet<LozengeOption> dropdownSet : list) {
                this.setEntityAccessor.saveLozengeSetUnTransactional(dropdownSet, spaceKey);
            }
        }
    }

    private void saveTextSetsInAo(List<DropdownSet<TextOption>> list, String spaceKey) {
        if (!list.isEmpty()) {
            for (DropdownSet<TextOption> dropdownSet : list) {
                this.setEntityAccessor.saveTextSetUnTransactional(dropdownSet, spaceKey);
            }
        }
    }

    private void saveGlobalLozengeSetHistoryInAo() {
        List<Object> globalStatusSetHistories = this.oldLozengeHistoryAccesor.getGlobalStatusSetHistories();
        List<SetHistory<LozengeOption>> setHistories = this.lozengeReflector.reflectLozengeSetHistory(globalStatusSetHistories);
        for (SetHistory<LozengeOption> globalStatusSetHistory : setHistories) {
            this.setHistoryAccesor.saveLozengeHistoryChangeNotTransactional(globalStatusSetHistory);
        }
    }

    private void saveGlobalTextSetHistoryInAo() {
        List<Object> globalStatusSetHistories = this.oldTextHistoryAccesor.getGlobalStatusSetHistories();
        List<SetHistory<TextOption>> histories = this.textReflector.reflectTextSetHistory(globalStatusSetHistories);
        for (SetHistory<TextOption> globalStatusSetHistory : histories) {
            this.setHistoryAccesor.saveTextHistoryChangeNotTransactional(globalStatusSetHistory);
        }
    }

    private void saveSpaceLozengeSetHistoryInAo(String spaceKey) {
        List<Object> spaceStatusSetHistories = this.oldLozengeHistoryAccesor.getSpaceStatusSetHistories(spaceKey);
        List<SetHistory<LozengeOption>> setHistories = this.lozengeReflector.reflectLozengeSetHistory(spaceStatusSetHistories);
        for (SetHistory<LozengeOption> globalStatusSetHistory : setHistories) {
            this.setHistoryAccesor.saveLozengeHistoryChangeNotTransactional(globalStatusSetHistory);
        }
    }

    private void saveSpaceTextSetHistoryInAo(String spaceKey) {
        List<Object> spaceStatusSetHistories = this.oldTextHistoryAccesor.getSpaceStatusSetHistories(spaceKey);
        List<SetHistory<TextOption>> histories = this.textReflector.reflectTextSetHistory(spaceStatusSetHistories);
        for (SetHistory<TextOption> history : histories) {
            this.setHistoryAccesor.saveTextHistoryChangeNotTransactional(history);
        }
    }
}

