/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.macros;

import eps.focuspro.edm.persistence.MigratorGeneral;
import eps.focuspro.rest.helper.MigrationInProgressException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroRunner {
    private static final Logger log = LoggerFactory.getLogger(MacroRunner.class);
    private final MigratorGeneral migratorGeneral;

    public MacroRunner(MigratorGeneral migratorGeneral) {
        this.migratorGeneral = migratorGeneral;
    }

    public String execute(Callable<String> callable) {
        try {
            this.migratorGeneral.check();
            return callable.call();
        }
        catch (MigrationInProgressException e) {
            log.error("Error Migration in Progress: {}", (Object)e.getMessage());
            return "Error rendering Easy Dropdown Menu - Migration in Progress";
        }
        catch (Exception e) {
            log.error("Error while rendering Macro: ", (Throwable)e);
            return "Error while rendering Easy Dropdown Menu Macro";
        }
    }
}

