/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.configui.OptionCalculator;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.macros.DropdownState;
import eps.focuspro.macros.EdmMacroUtils;
import eps.focuspro.macros.MacroRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class DropdownMenuEditMode
implements Macro {
    public static final String MACRO_NAME = "easy-dropdown-menu-edit-mode";
    private static final String FALLBACK_TEXT_SET_ID = "";
    private final OptionCalculator optionCalculator;
    private final SetEntityAccessor setEntityAccessor;
    private final EdmSettingsManager edmSettingsManager;
    private final MacroRunner macroRunner;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public DropdownMenuEditMode(SetEntityAccessor setEntityAccessor, OptionCalculator optionCalculator, EdmSettingsManager edmSettingsManager, MacroRunner macroRunner, SoyTemplateRenderer soyTemplateRenderer) {
        this.setEntityAccessor = setEntityAccessor;
        this.optionCalculator = optionCalculator;
        this.edmSettingsManager = edmSettingsManager;
        this.macroRunner = macroRunner;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) {
        return this.macroRunner.execute(() -> {
            EdmGlobalSettings databaseSettings = this.edmSettingsManager.getGlobalSettings();
            String dropdownSetId = parameters.get("set-id") == null ? FALLBACK_TEXT_SET_ID : (String)parameters.get("set-id");
            String optionIds = (String)parameters.get("option-id");
            String currentOptionValue = (String)parameters.get("current-option-value");
            ArrayList<String> optionIdList = optionIds == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(optionIds.split("\\s*,\\s*")));
            String chosenSeparator = this.getChosenSeparator((String)parameters.get("separator"));
            String defaultEditModeCss = databaseSettings.getDefaultEditModeCssClass();
            String style = EdmMacroUtils.getCssStyle(parameters, defaultEditModeCss);
            DropdownSet<TextOption> chosenTextOptionSet = this.setEntityAccessor.getTextSet(dropdownSetId);
            DropdownState dropdownState = EdmMacroUtils.getDropdownState(chosenTextOptionSet, currentOptionValue);
            if (!dropdownState.equals((Object)DropdownState.OK)) {
                return DropdownState.getMessage(dropdownState, currentOptionValue);
            }
            List<TextOption> options = this.optionCalculator.getTextOptions(chosenTextOptionSet, optionIdList);
            String webResource = "eps.focuspro.EasyDropdownMenu:edm-macro-soy-templates";
            return this.soyTemplateRenderer.render(webResource, "Confluence.Sap.macros.editModeMacro", this.getStorageMap(this.getOptionString(options, chosenSeparator), style));
        });
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    private String getChosenSeparator(String customSeparator) {
        return customSeparator != null ? customSeparator : ", ";
    }

    private String getOptionString(List<TextOption> options, String chosenSeparator) {
        StringJoiner stringJoiner = new StringJoiner(chosenSeparator);
        for (TextOption option : options) {
            stringJoiner.add(option.getName());
        }
        return stringJoiner.toString();
    }

    private Map<String, Object> getStorageMap(String options, String style) {
        HashMap<String, Object> storageMap = new HashMap<String, Object>();
        storageMap.put("style", style);
        storageMap.put("options", options);
        return storageMap;
    }
}

