/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.fix;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.LozengeEntityConverter;
import eps.focuspro.edm.persistence.TextEntityConverter;
import eps.focuspro.edm.persistence.entities.LozengeSetEntity;
import eps.focuspro.edm.persistence.entities.TextSetEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DuplicatedSetAccessor {
    private final ActiveObjects ao;
    private final LozengeEntityConverter lozengeEntityConverter;
    private final TextEntityConverter textEntityConverter;
    private final TransactionTemplate transactionTemplate;

    public DuplicatedSetAccessor(ActiveObjects ao, LozengeEntityConverter lozengeEntityConverter, TextEntityConverter textEntityConverter, TransactionTemplate transactionTemplate) {
        this.ao = Objects.requireNonNull(ao);
        this.lozengeEntityConverter = lozengeEntityConverter;
        this.textEntityConverter = textEntityConverter;
        this.transactionTemplate = transactionTemplate;
    }

    public Set<String> getAllLozengeSetNames(String spaceKey) {
        return (Set)this.transactionTemplate.execute(() -> {
            HashSet<String> setNames = new HashSet<String>();
            for (LozengeSetEntity lozengeSetEntity : (LozengeSetEntity[])this.ao.find(LozengeSetEntity.class)) {
                if (!spaceKey.equals(lozengeSetEntity.getSpaceKey())) continue;
                String setName = lozengeSetEntity.getSetName();
                setNames.add(setName);
            }
            return setNames;
        });
    }

    public Set<String> getAllTextSetNames(String spaceKey) {
        return (Set)this.transactionTemplate.execute(() -> {
            HashSet<String> setNames = new HashSet<String>();
            for (TextSetEntity lozengeSetEntity : (TextSetEntity[])this.ao.find(TextSetEntity.class)) {
                if (!spaceKey.equals(lozengeSetEntity.getSpaceKey())) continue;
                String setName = lozengeSetEntity.getSetName();
                setNames.add(setName);
            }
            return setNames;
        });
    }

    public List<DropdownSet<LozengeOption>> getLozengeSetsByName(String name, String spaceKey) {
        return (List)this.transactionTemplate.execute(() -> {
            ArrayList<DropdownSet<LozengeOption>> entities = new ArrayList<DropdownSet<LozengeOption>>();
            for (LozengeSetEntity lozengeSetEntity : (LozengeSetEntity[])this.ao.find(LozengeSetEntity.class)) {
                if (!lozengeSetEntity.getSetName().equals(name) || !spaceKey.equals(lozengeSetEntity.getSpaceKey())) continue;
                entities.add(this.lozengeEntityConverter.convertFromEntity(lozengeSetEntity));
            }
            return entities;
        });
    }

    public List<DropdownSet<TextOption>> getTextSetsByName(String name, String spaceKey) {
        return (List)this.transactionTemplate.execute(() -> {
            ArrayList<DropdownSet<TextOption>> entities = new ArrayList<DropdownSet<TextOption>>();
            for (TextSetEntity textSetEntity : (TextSetEntity[])this.ao.find(TextSetEntity.class)) {
                if (!textSetEntity.getSetName().equals(name) || !spaceKey.equals(textSetEntity.getSpaceKey())) continue;
                entities.add(this.textEntityConverter.convertFromEntity(textSetEntity));
            }
            return entities;
        });
    }
}

