/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.config.migration;

import eps.focuspro.edm.persistence.config.daos.Version1MappingsDao;
import eps.focuspro.migration.MigrationDatabase;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version1MappingsMigrator {
    private final MigrationDatabase migrationDatabase;
    private final Version1MappingsDao version1MappingsDao;
    private static final Logger log = LoggerFactory.getLogger(Version1MappingsDao.class);

    public Version1MappingsMigrator(MigrationDatabase migrationDatabase, Version1MappingsDao version1MappingsDao) {
        this.migrationDatabase = migrationDatabase;
        this.version1MappingsDao = version1MappingsDao;
    }

    public void migrateGlobal() {
        this.migrateGlobalSets();
    }

    public void migrateSpace(String spaceKey) {
        log.info("Migrating the space-set-mapping of space with key: " + spaceKey + " from bandana to ao");
        if (this.version1MappingsDao.getSpaceSetMapping(spaceKey).isEmpty()) {
            Map<String, String> spaceSetsMapping = this.migrationDatabase.getSpaceSetsMapping(spaceKey, "edm-status-space-set-mapping-key");
            spaceSetsMapping.putAll(this.migrationDatabase.getSpaceSetsMapping(spaceKey, "edm-text-space-set-mapping-key"));
            if (!spaceSetsMapping.isEmpty()) {
                this.version1MappingsDao.saveSetIdMappings(spaceSetsMapping, spaceKey);
                this.migrateOptionsOfSpace(spaceKey);
            }
        } else {
            log.info("Didn't migrate space-set-mapping from bandana for space: " + spaceKey + " as there were already mappings present!");
        }
    }

    private void migrateGlobalSets() {
        log.info("Migrating the global-set-mapping from bandana to ao");
        if (this.version1MappingsDao.getGlobalSetMapping().isEmpty()) {
            Map<String, String> globalSetsMapping = this.migrationDatabase.getGlobalSetsMapping("edm-status-global-set-mapping-key");
            globalSetsMapping.putAll(this.migrationDatabase.getGlobalSetsMapping("edm-text-global-set-mapping-key"));
            this.version1MappingsDao.saveSetIdMappings(globalSetsMapping, "");
            this.migrateGlobalOptions();
        } else {
            log.info("Didn't migrate global-set-mapping from bandana as there were already mappings present!");
        }
    }

    private void migrateGlobalOptions() {
        log.info("Migration global-options-mappings from bandana to ao");
        Map<String, Map<String, String>> globalOptionsMapping = this.migrationDatabase.getGlobalOptionsMapping("edm-status-global-options-mapping-key");
        globalOptionsMapping.putAll(this.migrationDatabase.getGlobalOptionsMapping("edm-text-global-options-mapping-key"));
        this.version1MappingsDao.saveOptionIdMappings(globalOptionsMapping);
    }

    private void migrateOptionsOfSpace(String spaceKey) {
        log.info("Migration space-options-mappings from bandana to ao");
        Map<String, Map<String, String>> spaceOptions = this.migrationDatabase.getSpaceOptionsMapping(spaceKey, "edm-status-space-options-mapping-key");
        spaceOptions.putAll(this.migrationDatabase.getSpaceOptionsMapping(spaceKey, "edm-text-space-options-mapping-key"));
        this.version1MappingsDao.saveOptionIdMappings(spaceOptions);
    }
}

