/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import eps.focuspro.cql.FieldCreator;
import eps.focuspro.cql.MacroValuesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldDescriptorService {
    private final MacroValuesProvider macroValuesProvider;
    private final FieldCreator fieldCreator;
    private static final Logger log = LoggerFactory.getLogger(FieldDescriptorService.class);

    public FieldDescriptorService(MacroValuesProvider macroValuesProvider, FieldCreator fieldCreator) {
        this.macroValuesProvider = macroValuesProvider;
        this.fieldCreator = fieldCreator;
    }

    public List<FieldDescriptor> computeEDMFieldDescriptors(XhtmlContent xhtmlContent, ConversionContext conversionContext, MacroDefinition macro) {
        List<FieldDescriptor> fieldDescriptorList = new ArrayList<FieldDescriptor>();
        Map parameters = macro.getParameters();
        String macroName = macro.getName();
        if (StringUtils.isNotBlank((CharSequence)macroName)) {
            switch (macroName) {
                case "easy-dropdown-menu": {
                    log.debug("Extracting non predefined field");
                    fieldDescriptorList = this.createNonPredefinedFields(parameters);
                    break;
                }
                case "easy-dropdown-menu-predefined": 
                case "easy-dropdown-menu-edit-mode": {
                    log.debug("Extracting text macro field");
                    fieldDescriptorList = this.createTextFields(parameters);
                    break;
                }
                case "easy-dropdown-menu-status": {
                    log.debug("Extracting status macro field");
                    fieldDescriptorList = this.createStatusFields(parameters);
                    break;
                }
                case "details": {
                    log.debug("Extracting pageProperty Report macro");
                    fieldDescriptorList = this.extractFieldDescriptorFromTable(xhtmlContent, conversionContext, macro);
                    break;
                }
            }
        }
        return fieldDescriptorList;
    }

    private List<FieldDescriptor> createNonPredefinedFields(Map<String, String> parameters) {
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        List<String> currentOptionIdsFromText = this.macroValuesProvider.getCurrentOptionIdsFromText(parameters);
        List<String> currentOptionList = this.macroValuesProvider.getCurrentOptionListFromNonPredefinedMacro(parameters);
        List<FieldDescriptor> fieldDescriptors = this.fieldCreator.createFullOptionDescriptors(currentOptionList, "EdmOption", "");
        fieldDescriptors.addAll(this.fieldCreator.createSetAndOptionIdDescriptors(setId, currentOptionIdsFromText));
        return fieldDescriptors;
    }

    private List<FieldDescriptor> createTextFields(Map<String, String> parameters) {
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        List<String> currentOptionIdsFromText = this.macroValuesProvider.getCurrentOptionIdsFromText(parameters);
        List<String> currentOptionsList = this.macroValuesProvider.getCurrentOptionListFromTextMacro(setId, currentOptionIdsFromText);
        List<FieldDescriptor> fieldDescriptors = this.fieldCreator.createFullOptionDescriptors(currentOptionsList, "EdmOption", "");
        fieldDescriptors.addAll(this.fieldCreator.createSetAndOptionIdDescriptors(setId, currentOptionIdsFromText));
        return fieldDescriptors;
    }

    private List<FieldDescriptor> createStatusFields(Map<String, String> parameters) {
        String optionId;
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        String currentOptionValue = this.macroValuesProvider.getCurrentOptionFromStatusMacro(setId, optionId = this.macroValuesProvider.getCurrentOptionIdFromStatus(parameters));
        if (currentOptionValue != null) {
            fields.addAll(this.fieldCreator.createFullOptionDescriptors(Collections.singletonList(currentOptionValue), "EdmStatusOption", ""));
        }
        fields.addAll(this.fieldCreator.createSetAndOptionIdDescriptors(setId, Collections.singletonList(optionId)));
        return fields;
    }

    private List<FieldDescriptor> createNonPredefinedFieldsLinkedToTitle(Map<String, String> parameters, String pageProperty) {
        List<String> currentOptionValueList = this.macroValuesProvider.getCurrentOptionListFromNonPredefinedMacro(parameters);
        return this.fieldCreator.createFullOptionDescriptors(currentOptionValueList, "EdmOption", pageProperty);
    }

    private List<FieldDescriptor> createPredefinedFieldsLinkedToTitle(Map<String, String> parameters, String pageProperty) {
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        List<String> currentOptionIdsFromText = this.macroValuesProvider.getCurrentOptionIdsFromText(parameters);
        List<String> currentOptionsList = this.macroValuesProvider.getCurrentOptionListFromTextMacro(setId, currentOptionIdsFromText);
        return this.fieldCreator.createFullOptionDescriptors(currentOptionsList, "EdmOption", pageProperty);
    }

    private List<FieldDescriptor> createStatusFieldsLinkedToTitle(Map<String, String> parameters, String pageProperty) {
        String currentOptionId;
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        String currentOptionValue = this.macroValuesProvider.getCurrentOptionFromStatusMacro(setId, currentOptionId = this.macroValuesProvider.getCurrentOptionIdFromStatus(parameters));
        if (StringUtils.isNotBlank((CharSequence)currentOptionValue)) {
            return this.fieldCreator.createFullOptionDescriptors(Collections.singletonList(currentOptionValue), "EdmStatusOption", pageProperty);
        }
        return Collections.emptyList();
    }

    private List<FieldDescriptor> extractFieldDescriptorFromTable(XhtmlContent xhtmlContent, ConversionContext conversionContext, MacroDefinition macro) {
        Element table = this.getTableElementInsidePageProperties(macro);
        boolean isVertical = table.select("tr").stream().allMatch(row -> row.selectFirst("th") != null);
        if (isVertical) {
            return this.extractVerticalFieldDescriptors(table, xhtmlContent, conversionContext);
        }
        return this.extractHorizontalFieldDescriptors(table, xhtmlContent, conversionContext);
    }

    private List<FieldDescriptor> extractVerticalFieldDescriptors(Element table, XhtmlContent xhtmlContent, ConversionContext conversionContext) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        for (Element row : table.select("tr")) {
            String pageProperty;
            Element th = row.selectFirst("th");
            Element td = row.selectFirst("td");
            if (th == null || td == null || !StringUtils.isNotBlank((CharSequence)(pageProperty = th.text()))) continue;
            String cellContent = td.toString();
            fieldDescriptors.addAll(this.extractMacroValuesFromCell(xhtmlContent, cellContent, conversionContext, pageProperty));
        }
        return fieldDescriptors;
    }

    private List<FieldDescriptor> extractHorizontalFieldDescriptors(Element table, XhtmlContent xhtmlContent, ConversionContext conversionContext) {
        Element headerRow = table.selectFirst("tr");
        Elements headers = headerRow.select("th");
        Map<Element, Integer> headerToIndex = IntStream.range(0, headers.size()).boxed().collect(Collectors.toMap(((List)headers)::get, i -> i));
        Map<Element, Element> tableMap = this.generateHeaderToDataMap((List<Element>)headers, headerToIndex, table);
        return this.extractFieldDescriptorsFromMap(tableMap, xhtmlContent, conversionContext);
    }

    private Map<Element, Element> generateHeaderToDataMap(List<Element> headers, Map<Element, Integer> headerToIndex, Element table) {
        return headers.stream().map(header -> Map.entry(header, FieldDescriptorService.getMatchingTd(header, headerToIndex, table))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Element getTableElementInsidePageProperties(MacroDefinition macro) {
        String macroBodyString = macro.getStorageBodyStream().toString();
        Document macroBodyDocument = Jsoup.parse((String)macroBodyString, (String)"", (Parser)Parser.xmlParser());
        macroBodyDocument.outputSettings().prettyPrint(false);
        return macroBodyDocument.select("table").first();
    }

    private List<FieldDescriptor> extractFieldDescriptorsFromMap(Map<Element, Element> tableMap, XhtmlContent xhtmlContent, ConversionContext conversionContext) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        tableMap.forEach((header, entry) -> {
            String pageProperty = header.text();
            if (StringUtils.isNotBlank((CharSequence)pageProperty)) {
                String cellContent = entry.toString();
                fieldDescriptors.addAll(this.extractMacroValuesFromCell(xhtmlContent, cellContent, conversionContext, pageProperty));
            }
        });
        return fieldDescriptors;
    }

    private List<FieldDescriptor> extractMacroValuesFromCell(XhtmlContent xhtmlContent, String cellContent, ConversionContext conversionContext, String pageProperty) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        try {
            xhtmlContent.handleMacroDefinitions(cellContent, conversionContext, macroDefinition -> {
                List<FieldDescriptor> extractedFields = this.extractFieldDescriptorFromMacroInCell(macroDefinition, pageProperty);
                fields.addAll(extractedFields);
            });
        }
        catch (XhtmlException e) {
            log.warn("An Error occurred Filtering out Macros of Td Element in PageProperties", (Throwable)e);
            log.debug("The cellContent was: {}", (Object)cellContent);
        }
        return fields;
    }

    private List<FieldDescriptor> extractFieldDescriptorFromMacroInCell(MacroDefinition macro, String pageProperty) {
        Map parameters = macro.getParameters();
        String macroName = macro.getName();
        if (StringUtils.isNotBlank((CharSequence)macroName)) {
            switch (macroName) {
                case "easy-dropdown-menu": {
                    return this.createNonPredefinedFieldsLinkedToTitle(parameters, pageProperty);
                }
                case "easy-dropdown-menu-predefined": 
                case "easy-dropdown-menu-edit-mode": {
                    return this.createPredefinedFieldsLinkedToTitle(parameters, pageProperty);
                }
                case "easy-dropdown-menu-status": {
                    return this.createStatusFieldsLinkedToTitle(parameters, pageProperty);
                }
            }
        }
        return Collections.emptyList();
    }

    public static Element getMatchingTd(Element th, Map<Element, Integer> headerIndex, Element table) {
        Integer columnIndex = headerIndex.get(th);
        Element tableRow = table.select("tr").stream().filter(r -> !r.select("td").isEmpty()).findFirst().orElseThrow(() -> new IllegalStateException("No data row in table"));
        return (Element)tableRow.select("td").get(columnIndex.intValue());
    }
}

