/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.ConversionContextCreator;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import eps.focuspro.cql.FieldDescriptorService;
import eps.focuspro.cql.TextExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdmMacroExtractor
implements Extractor2 {
    public static final String INDEXABLE_PROPERTY_TEXT_OPTION = "EdmOption";
    public static final String INDEXABLE_PROPERTY_STATUS_OPTION = "EdmStatusOption";
    public static final String PAGEPROPERTY_MACRO_NAME = "details";
    public static final String INDEXABLE_PROPERTY_SET_ID = "EdmSetId";
    public static final String INDEXABLE_PROPERTY_OPTION_ID = "EdmOptionId";
    private static final Logger log = LoggerFactory.getLogger(EdmMacroExtractor.class);
    private final XhtmlContent xhtmlContent;
    private final FieldDescriptorService fieldDescriptorService;
    private final TextExtractor textExtractor;

    public EdmMacroExtractor(XhtmlContent xhtmlContent, FieldDescriptorService fieldDescriptorService, TextExtractor textExtractor) {
        this.xhtmlContent = xhtmlContent;
        this.fieldDescriptorService = fieldDescriptorService;
        this.textExtractor = textExtractor;
    }

    public StringBuilder extractText(Object searchable) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Function<ConversionContext, MacroDefinitionHandler> currentValueAppendHandlerCreateFunction = conversionContext -> macro -> {
                StringBuilder newStringBuilder = this.textExtractor.getExtractTextStringBuilder(macro);
                stringBuilder.append((CharSequence)newStringBuilder);
            };
            this.handleDropdownMacros(searchable, currentValueAppendHandlerCreateFunction);
            return stringBuilder;
        }
        catch (Exception e) {
            log.warn("An Exception occurred extracting text from macros", (Throwable)e);
            return new StringBuilder();
        }
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        try {
            ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
            Function<ConversionContext, MacroDefinitionHandler> currentOptionValueToFieldDescriptionAppenderCreator = conversionContext -> macroDefinition -> {
                List<FieldDescriptor> fields = this.fieldDescriptorService.computeEDMFieldDescriptors(this.xhtmlContent, (ConversionContext)conversionContext, macroDefinition);
                fieldDescriptors.addAll(fields);
            };
            this.handleDropdownMacros(searchable, currentOptionValueToFieldDescriptionAppenderCreator);
            return fieldDescriptors;
        }
        catch (Exception e) {
            log.warn("An Exception occurred extracting fields from macros", (Throwable)e);
            return new ArrayList<FieldDescriptor>();
        }
    }

    private void handleDropdownMacros(Object searchable, Function<ConversionContext, MacroDefinitionHandler> macroDefinitionHandler) {
        if (searchable instanceof ContentEntityObject) {
            ContentEntityObject entityObject = (ContentEntityObject)searchable;
            if (StringUtils.equals((CharSequence)entityObject.getType(), (CharSequence)"page")) {
                log.debug("Extracting fields of page with title: {}", (Object)entityObject.getDisplayTitle());
                ConversionContext conversionContext = new ConversionContextCreator().createConversionContext(entityObject);
                try {
                    this.xhtmlContent.handleMacroDefinitions(entityObject.getBodyAsString(), conversionContext, macroDefinitionHandler.apply(conversionContext));
                }
                catch (XhtmlException e) {
                    log.warn("An Exception occurred when handling Macros", (Throwable)e);
                    log.debug("The PageBody was: {}", (Object)entityObject.getBodyAsString());
                    log.debug("The ContentId was: {}", (Object)entityObject.getContentId());
                }
            } else {
                log.debug("Skipping extraction of type '{}' with title '{}'", (Object)entityObject.getType(), (Object)entityObject.getDisplayTitle());
            }
        }
    }
}

