/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui.helper;

import com.atlassian.confluence.web.UrlBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImagePlaceholderHelper {
    public static String createUrlSingleMultiPlaceholder(String textToDisplay, int imageWidth, boolean isStateMessage, boolean isMultiSelect) {
        UrlBuilder urlBuilder = isMultiSelect ? new UrlBuilder("/plugins/servlet/eps-easydropdownmenu/multiselect/placeholder") : new UrlBuilder("/plugins/servlet/eps-easydropdownmenu/singleselect/placeholder");
        urlBuilder.add("text", textToDisplay);
        urlBuilder.add("length", imageWidth);
        urlBuilder.add("isStateMessage", isStateMessage);
        return urlBuilder.toUrl();
    }

    public static void setBackground(int imageWidth, int imageHeight, Color color, BufferedImage image, Graphics2D graphics2D) {
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, imageWidth, imageHeight);
        ImagePlaceholderHelper.roundCorners(imageWidth, imageHeight, image);
    }

    public static void drawText(Graphics2D graphics2D, String text, Font font, Color fontColor, int x, int y) {
        graphics2D.setFont(font);
        graphics2D.setColor(fontColor);
        graphics2D.drawString(text, x, y);
    }

    public static void setBorderWithColor(Graphics2D graphics2D, Color borderColor, int imageHeight, int imageWidth) {
        graphics2D.setColor(borderColor);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawRect(0, 0, imageWidth, imageHeight);
    }

    private static void roundCorners(int imageWidth, int imageHeight, BufferedImage image) {
        int rbgWhite = Color.WHITE.getRGB();
        image.setRGB(0, 0, rbgWhite);
        image.setRGB(imageWidth - 1, 0, rbgWhite);
        image.setRGB(imageWidth - 1, imageHeight - 1, rbgWhite);
        image.setRGB(0, imageHeight - 1, rbgWhite);
    }
}

