/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui;

import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PermittedGroupsCollector {
    private final EdmSettingsManager edmSettingsManager;

    public PermittedGroupsCollector(EdmSettingsManager edmSettingsManager) {
        this.edmSettingsManager = edmSettingsManager;
    }

    public List<String> collect(Map<String, String> parameters, String spaceKey, EdmGlobalSettings globalEdmConfig) {
        HashSet<String> allGroups = new HashSet<String>(globalEdmConfig.getPermittedGroups());
        allGroups.addAll(this.getGroupsFromSpaceSettings(spaceKey));
        allGroups.addAll(this.getGroupsFromMacro(parameters));
        return new ArrayList<String>(allGroups);
    }

    public List<String> getGroupsFromSpaceSettings(String spaceKey) {
        return this.edmSettingsManager.getSpaceSettings(spaceKey).getPermittedGroups();
    }

    private List<String> getGroupsFromMacro(Map<String, String> parameters) {
        String groupsFromMacroString = parameters.get("permitted-groups");
        if (groupsFromMacroString == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(groupsFromMacroString.split(","));
    }
}

