/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui;

import eps.focuspro.configui.helper.ImagePlaceholderHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePlaceholderStatusGenerator
extends HttpServlet {
    private static final int imageHeight = 24;
    private static final Font font = new Font("Monospaced", 1, 15);
    private static final Logger log = LoggerFactory.getLogger(ImagePlaceholderStatusGenerator.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String text = req.getParameter("text");
        String color = req.getParameter("color");
        boolean subtle = Boolean.parseBoolean(req.getParameter("subtle"));
        boolean textWhite = Boolean.parseBoolean(req.getParameter("textWhite"));
        int imageWidth = Integer.parseInt(req.getParameter("length"));
        HashMap<String, Color> colorSettings = this.getColorFromReq(color, subtle, textWhite);
        Color backgroundColor = colorSettings.get("backgroundColor");
        Color fontColor = colorSettings.get("fontColor");
        Color borderColor = colorSettings.get("borderColor");
        BufferedImage image = new BufferedImage(imageWidth, 24, 1);
        Graphics2D graphics2D = image.createGraphics();
        ImagePlaceholderHelper.setBackground(imageWidth, 24, backgroundColor, image, graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ImagePlaceholderHelper.drawText(graphics2D, text, font, fontColor, 15, 17);
        ImagePlaceholderHelper.setBorderWithColor(graphics2D, borderColor, 24, imageWidth);
        resp.setContentType("image/png");
        try {
            ImageIO.write((RenderedImage)image, "png", (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            log.error("Error on EditorPlaceholder", (Throwable)e);
        }
    }

    private HashMap<String, Color> getColorFromReq(String colorString, boolean subtle, boolean textWhite) {
        HashMap<String, Color> colorSettings = new HashMap<String, Color>();
        Color color = Color.decode(colorString);
        if (subtle) {
            colorSettings.put("backgroundColor", Color.white);
            colorSettings.put("fontColor", color);
            colorSettings.put("borderColor", color);
        } else {
            colorSettings.put("backgroundColor", color);
            colorSettings.put("fontColor", textWhite ? Color.white : Color.black);
            if (!textWhite) {
                colorSettings.put("borderColor", color);
            }
        }
        return colorSettings;
    }
}

