/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.thoughtworks.xstream.XStream;
import eps.focuspro.configui.DatabaseSettings;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DatabaseSettingsManager {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSettingsManager.class);
    private static final String ADD_ON_KEY = "eps.easydropdownmenu-database";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final XStream xStream;

    public DatabaseSettingsManager(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.xStream = new XStream();
        this.xStream.setClassLoader(DatabaseSettingsManager.class.getClassLoader());
    }

    public DatabaseSettings getDbSettings() {
        return this.loadSettings();
    }

    public void save(DatabaseSettings dbSettings) {
        try {
            PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
            String xml = this.xStream.toXML((Object)dbSettings);
            pluginSettings.put(ADD_ON_KEY, (Object)xml);
        }
        catch (Exception e) {
            log.warn("Could not save setting in database", (Throwable)e);
        }
    }

    public DatabaseSettings getDefaultDbSettings() {
        DatabaseSettings settings = new DatabaseSettings();
        settings.setCssColorValidValue("");
        settings.setCssColorInvalidValue("");
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("Months", "January,February,March,April,May,June,July,August,September,November,December");
        optionsMap.put("Contacts", "CEO (Chief Executive Officer),CFO (Chief Financial Officer),CMO (Chief Marketing Officer),COO (Chief Operation Officer),CTO (Chief Technical Officer),Part-Time-Employee,Full-Time-Employee,Trainee");
        optionsMap.put("File extensions", ".doc,.pdf,.txt,.jpg,.gif,.mp3,.html,.exe");
        optionsMap.put("Weekdays", "Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday");
        HashMap<String, Map<String, String>> statusOptionMap = new HashMap<String, Map<String, String>>();
        statusOptionMap.put("Default", this.getDefaultStatusMap());
        statusOptionMap.put("Traffic light", this.getStatusMap(new String[]{"Stop", "Go if possible", "Go!"}));
        statusOptionMap.put("Email Status", this.getStatusMap(new String[]{"Waiting for E-Mail", "Reply to E-Mail", "E-Mail sent", "Created draft E-Mail", "E-Mail deleted", "Junk E-Mail"}));
        statusOptionMap.put("Ticket Status", this.getStatusMap(new String[]{"Waiting for Customer", "In progress", "Investigating", "Escalated", "Canceled", "Resolved"}));
        statusOptionMap.put("Active Sprint Status", this.getStatusMap(new String[]{"Ready", "Postponed", "In progress", "Review", "Done"}));
        settings.setConfigStatusOptions(statusOptionMap);
        settings.setDropdownOptionsMap(optionsMap);
        settings.setDefaultDropdownOptions("");
        settings.setCssDropdownMenu("background:#EEEEEE");
        settings.setCssDropdownMenuPredefined("");
        settings.setCssEditModeValid("");
        settings.setCssEditModeInvalid("");
        settings.setEditModeTextNoValue("");
        settings.setSuppressNotifications(true);
        settings.setAllowAnonymous(false);
        settings.setAllowWithoutEditPermissions(false);
        return settings;
    }

    private DatabaseSettings loadSettings() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get(ADD_ON_KEY);
        if (!(value instanceof String)) {
            if (value != null) {
                log.warn("Unknown format of settings {} - loading default settings", (Object)value.getClass().getName());
            } else {
                log.info("Loading initial settings");
            }
            return this.getDefaultDbSettings();
        }
        DatabaseSettings dbSettings = this.xmlToDbSettings(value.toString());
        return dbSettings != null ? dbSettings : this.getDefaultDbSettings();
    }

    private DatabaseSettings xmlToDbSettings(String xmlString) {
        try {
            Object xml = this.xStream.fromXML(xmlString);
            return (DatabaseSettings)xml;
        }
        catch (Exception e) {
            log.warn("Current Settings {}", (Object)xmlString);
            log.warn("Could not convert EDM settings from XML - loading default settings", (Throwable)e);
            return this.getDefaultDbSettings();
        }
    }

    private Map<String, String> getDefaultStatusMap() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("green", "SUCCESS");
        valueMap.put("blue", "COMPLETE");
        valueMap.put("yellow", "CURRENT");
        valueMap.put("red", "ERROR");
        valueMap.put("brown", "MOVED");
        valueMap.put("grey", "GENERIC");
        return valueMap;
    }

    private Map<String, String> getStatusMap(String[] statusOptionValues) {
        String[] colors = new String[]{"green", "blue", "yellow", "red", "brown", "grey"};
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (int i = 0; i < statusOptionValues.length && i < colors.length; ++i) {
            valueMap.put(colors[i], statusOptionValues[i]);
        }
        return valueMap;
    }
}

