/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.helper;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import eps.focuspro.PermissionValidator;
import eps.focuspro.edm.persistence.MigratorGeneral;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.license.LicenseStatus;
import eps.focuspro.license.LicenseValidator;
import eps.focuspro.rest.helper.ExecutionGuard;
import eps.focuspro.rest.helper.ResourceContext;
import eps.focuspro.rest.helper.exceptions.PermissionValidationException;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesRunner
extends ExecutionGuard {
    private final LicenseValidator licenseValidator;
    private final MigratorGeneral migratorGeneral;
    private final PermissionValidator permissionValidator;
    private static final Logger log = LoggerFactory.getLogger(ResourcesRunner.class);
    private final EdmSettingsManager edmSettingsManager;

    public ResourcesRunner(LicenseValidator licenseValidator, MigratorGeneral migratorGeneral, PermissionValidator permissionValidator, EdmSettingsManager edmSettingsManager) {
        this.licenseValidator = licenseValidator;
        this.migratorGeneral = migratorGeneral;
        this.permissionValidator = permissionValidator;
        this.edmSettingsManager = edmSettingsManager;
    }

    public Response run(Callable<Response> callable, ResourceContext resourceContext) {
        return this.execute(() -> {
            LicenseStatus licenseStatus;
            if (resourceContext.isNeedMigrationCheck()) {
                this.migratorGeneral.check();
            }
            if (resourceContext.isNeedGlobalAdmin()) {
                this.checkAdmin();
            }
            if (resourceContext.isNeedSpaceAdmin()) {
                this.checkSpaceAdmin(resourceContext.getSpaceKey());
            }
            if (resourceContext.isNeedEditPermission()) {
                this.checkPageEditPermission(resourceContext.getPageId());
            }
            if (resourceContext.isNeedPluginLicense() && (licenseStatus = this.licenseValidator.validatePluginLicense()) != LicenseStatus.VALID) {
                return this.licenseValidator.getResponse(licenseStatus);
            }
            return (Response)callable.call();
        });
    }

    private void checkAdmin() {
        boolean isAdmin = this.permissionValidator.isCurrentUserAdmin((User)AuthenticatedUserThreadLocal.get());
        if (!isAdmin) {
            String message = "Admin rights required";
            log.error(message);
            throw new PermissionValidationException(message);
        }
    }

    private void checkSpaceAdmin(String spaceKey) {
        boolean isSpaceAdmin = this.permissionValidator.isCurrentUserSpaceAdmin((User)AuthenticatedUserThreadLocal.get(), spaceKey);
        if (!isSpaceAdmin) {
            String message = "Space Admin rights required";
            log.error(message);
            throw new PermissionValidationException(message);
        }
    }

    private void checkPageEditPermission(long pageId) {
        boolean hasEditPermission = this.permissionValidator.isEditingAllowed(pageId, this.edmSettingsManager.getGlobalSettings());
        if (!hasEditPermission) {
            String message = "No edit permission granted";
            log.error(message);
            throw new PermissionValidationException(message);
        }
    }
}

