/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class MigrationTask<T, R, U, V> {
    private Supplier<T> loader;
    private Function<T, R> converter;
    private Function<R, U> setMapper;
    private Function<R, V> optionsMapper;
    private Consumer<R> setSaver;
    private BiConsumer<U, V> mappingSaver;

    public void migrate() {
        T t = this.loader.get();
        R r = this.converter.apply(t);
        U u = this.setMapper.apply(r);
        V v = this.optionsMapper.apply(r);
        this.setSaver.accept(r);
        this.mappingSaver.accept(u, v);
    }

    public void setLoader(Supplier<T> loader) {
        this.loader = loader;
    }

    public void setConverter(Function<T, R> converter) {
        this.converter = converter;
    }

    public void setSetMapper(Function<R, U> setMapper) {
        this.setMapper = setMapper;
    }

    public void setOptionsMapper(Function<R, V> optionsMapper) {
        this.optionsMapper = optionsMapper;
    }

    public void setSetSaver(Consumer<R> setSaver) {
        this.setSaver = setSaver;
    }

    public void setMappingSaver(BiConsumer<U, V> mappingSaver) {
        this.mappingSaver = mappingSaver;
    }
}

