/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.fix;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Option;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.fix.DuplicatedSetAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DuplicationFinder {
    private DuplicatedSetAccessor duplicatedSetAccessor;

    public DuplicationFinder(DuplicatedSetAccessor duplicatedSetAccessor) {
        this.duplicatedSetAccessor = duplicatedSetAccessor;
    }

    public List<DropdownSet<LozengeOption>> getFirstDuplicatedStatusSetList(String spaceKey) {
        Set<String> setNames = this.duplicatedSetAccessor.getAllLozengeSetNames(spaceKey);
        for (String setName : this.getSortedNames(setNames)) {
            List<DropdownSet<LozengeOption>> sets = this.duplicatedSetAccessor.getLozengeSetsByName(setName, spaceKey);
            if (!this.isDuplicated(sets)) continue;
            return sets;
        }
        return null;
    }

    public List<DropdownSet<TextOption>> getFirstDuplicatedTextSetList(String spaceKey) {
        Set<String> setNames = this.duplicatedSetAccessor.getAllTextSetNames(spaceKey);
        for (String setName : this.getSortedNames(setNames)) {
            List<DropdownSet<TextOption>> sets = this.duplicatedSetAccessor.getTextSetsByName(setName, spaceKey);
            if (!this.isDuplicated(sets)) continue;
            return sets;
        }
        return null;
    }

    private <T extends Option> boolean isDuplicated(List<DropdownSet<T>> sets) {
        return sets.size() > 1;
    }

    private List<String> getSortedNames(Set<String> setNames) {
        ArrayList<String> sorted = new ArrayList<String>(setNames);
        Collections.sort(sorted);
        return sorted;
    }
}

