/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.HistoryLozengeEntityConverter;
import eps.focuspro.edm.persistence.HistoryTextEntityConverter;
import eps.focuspro.edm.persistence.entities.SetHistoryEntity;
import eps.focuspro.history.historyObjects.SetHistory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetHistoryAccesor {
    private final ActiveObjects ao;
    private final HistoryLozengeEntityConverter historyLozengeEntityConverter;
    private final HistoryTextEntityConverter historyTextEntityConverter;
    private final AccessModeService accessModeService;
    private static final Logger log = LoggerFactory.getLogger(SetHistoryAccesor.class);

    public SetHistoryAccesor(ActiveObjects ao, AccessModeService accessModeService) {
        this.ao = Objects.requireNonNull(ao);
        this.historyLozengeEntityConverter = new HistoryLozengeEntityConverter();
        this.historyTextEntityConverter = new HistoryTextEntityConverter();
        this.accessModeService = accessModeService;
    }

    public SetHistory<LozengeOption> getLozengeHistoryChange(String setId) {
        List<SetHistoryEntity> setHistoryChangeEntityList = this.getSetHistoryChangeEntity(setId);
        return this.historyLozengeEntityConverter.convertFromEntity(setHistoryChangeEntityList, setId);
    }

    public void deleteSetHistory(String setId) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            log.warn("Couldn't delete set history because read only mode is active.");
            throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
        }
        this.deleteOldEntities(setId);
    }

    public void saveLozengeHistoryChangeNotTransactional(SetHistory<LozengeOption> setHistory) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            log.warn("Couldn't save status set history because read only mode is active.");
            throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
        }
        this.deleteOldEntities(setHistory.getSetId());
        this.historyLozengeEntityConverter.convertToEntity(setHistory, this.ao);
    }

    public SetHistory<TextOption> getTextHistoryChange(String setId) {
        List<SetHistoryEntity> setHistoryEntities = this.getSetHistoryChangeEntity(setId);
        return this.historyTextEntityConverter.convertFromEntity(setHistoryEntities, setId);
    }

    public void saveTextHistoryChangeNotTransactional(SetHistory<TextOption> setHistory) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            log.warn("Couldn't save text set history because read only mode is active.");
            throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
        }
        this.deleteOldEntities(setHistory.getSetId());
        this.historyTextEntityConverter.convertToEntity(setHistory, this.ao);
    }

    private List<SetHistoryEntity> getSetHistoryChangeEntity(String setId) {
        ArrayList<SetHistoryEntity> setHistoryChangeEntityList = new ArrayList<SetHistoryEntity>();
        for (SetHistoryEntity setHistoryChangeEntity : (SetHistoryEntity[])this.ao.find(SetHistoryEntity.class)) {
            if (!setId.equals(setHistoryChangeEntity.getSetId())) continue;
            setHistoryChangeEntityList.add(setHistoryChangeEntity);
        }
        return setHistoryChangeEntityList;
    }

    private void deleteOldEntities(String setId) {
        for (SetHistoryEntity entity : (SetHistoryEntity[])this.ao.find(SetHistoryEntity.class)) {
            if (!setId.equals(entity.getSetId())) continue;
            this.ao.delete(new RawEntity[]{entity});
        }
    }
}

