/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.LozengeEntityConverter;
import eps.focuspro.edm.persistence.TextEntityConverter;
import eps.focuspro.edm.persistence.entities.LozengeOptionEntity;
import eps.focuspro.edm.persistence.entities.LozengeSetEntity;
import eps.focuspro.edm.persistence.entities.TextOptionEntity;
import eps.focuspro.edm.persistence.entities.TextSetEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetEntityAccessor {
    private final ActiveObjects ao;
    private final LozengeEntityConverter lozengeEntityConverter;
    private final TextEntityConverter textEntityConverter;
    private final AccessModeService accessModeService;
    private static final Logger log = LoggerFactory.getLogger(SetEntityAccessor.class);

    public SetEntityAccessor(ActiveObjects ao, AccessModeService accessModeService) {
        this.ao = Objects.requireNonNull(ao);
        this.lozengeEntityConverter = new LozengeEntityConverter();
        this.textEntityConverter = new TextEntityConverter();
        this.accessModeService = accessModeService;
    }

    public void saveLozengeSetUnTransactional(DropdownSet<LozengeOption> dropdownSet, String spaceKey) {
        LozengeSetEntity existingEntity;
        if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
            existingEntity = this.getLozengeSetEntity(dropdownSet.getId());
            if (existingEntity == null) {
                existingEntity = (LozengeSetEntity)this.ao.create(LozengeSetEntity.class, new DBParam[0]);
            }
        } else {
            log.warn("Saving dropdownset with name : " + dropdownSet.getName() + " isn't possible because read-only mode is active.");
            throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
        }
        this.updateLozengeEntity(dropdownSet, spaceKey, existingEntity);
        existingEntity.save();
        log.info("Saving dropdownset with name : " + dropdownSet.getName() + " and id: " + dropdownSet.getId());
    }

    public void saveTextSetUnTransactional(DropdownSet<TextOption> dropdownSet, String spaceKey) {
        TextSetEntity existingEntity;
        if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
            existingEntity = this.getTextSetEntity(dropdownSet.getId());
            if (existingEntity == null) {
                existingEntity = (TextSetEntity)this.ao.create(TextSetEntity.class, new DBParam[0]);
            }
        } else {
            log.warn("Saving dropdownset with name : " + dropdownSet.getName() + " isn't possible because read-only mode is active.");
            throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
        }
        this.updateTextEntity(dropdownSet, spaceKey, existingEntity);
        existingEntity.save();
        log.info("Saving dropdownset with name : " + dropdownSet.getName() + " and id: " + dropdownSet.getId());
    }

    public DropdownSet<LozengeOption> getLozengeSet(String id) {
        return this.lozengeEntityConverter.convertFromEntity(this.getLozengeSetEntity(id));
    }

    public DropdownSet<TextOption> getTextSet(String id) {
        return this.textEntityConverter.convertFromEntity(this.getTextSetEntity(id));
    }

    public List<DropdownSet<LozengeOption>> getLozengeSets(String spaceKey) {
        ArrayList<DropdownSet<LozengeOption>> setsList = new ArrayList<DropdownSet<LozengeOption>>();
        setsList.addAll(this.getSpaceLozengeSets(spaceKey));
        setsList.addAll(this.getGlobalLozengeSets());
        return setsList;
    }

    public List<DropdownSet<TextOption>> getTextSets(String spaceKey) {
        ArrayList<DropdownSet<TextOption>> setsList = new ArrayList<DropdownSet<TextOption>>();
        setsList.addAll(this.getSpaceTextSets(spaceKey));
        setsList.addAll(this.getGlobalTextSets());
        return setsList;
    }

    public List<DropdownSet<LozengeOption>> getLozengeSetsSpaceOrGlobal(String spaceKey) {
        List<LozengeSetEntity> setEntities = this.getLozengeSetEntities(spaceKey);
        return setEntities.stream().map(this.lozengeEntityConverter::convertFromEntity).collect(Collectors.toList());
    }

    public List<DropdownSet<TextOption>> getTextSetsSpaceOrGlobal(String spaceKey) {
        List<TextSetEntity> setEntities = this.getTextSetEntities(spaceKey);
        return setEntities.stream().map(this.textEntityConverter::convertFromEntity).collect(Collectors.toList());
    }

    public void deleteTextSetEntity(String setId) {
        if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
            TextSetEntity textSetEntity = this.getTextSetEntity(setId);
            if (textSetEntity != null) {
                for (TextOptionEntity textOptionEntity : textSetEntity.getOptionsArray()) {
                    this.ao.delete(new RawEntity[]{textOptionEntity});
                }
                this.ao.delete(new RawEntity[]{textSetEntity});
                log.info("Deleting Easy Dropdown Menu Set with id: " + setId);
            }
        } else {
            log.warn("Couldn't delete text set because readonly mode is active");
            throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
        }
    }

    public void deleteLozengeSetEntity(String setId) {
        if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
            LozengeSetEntity lozengeSetEntity = this.getLozengeSetEntity(setId);
            if (lozengeSetEntity != null) {
                for (LozengeOptionEntity lozengeOptionEntity : lozengeSetEntity.getOptionsArray()) {
                    this.ao.delete(new RawEntity[]{lozengeOptionEntity});
                }
                this.ao.delete(new RawEntity[]{lozengeSetEntity});
                log.info("Deleting Easy Dropdown Menu Set with id: " + setId);
            }
        } else {
            log.warn("Couldn't delete text set because readonly mode is active");
            throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
        }
    }

    public boolean areThereNoStatusSetsPresent(String spaceKey) {
        for (LozengeSetEntity lozengeSetEntity : (LozengeSetEntity[])this.ao.find(LozengeSetEntity.class)) {
            if (!(!spaceKey.isEmpty() ? spaceKey.equals(lozengeSetEntity.getSpaceKey()) : lozengeSetEntity.getSpaceKey() == null || lozengeSetEntity.getSpaceKey().equals(spaceKey))) continue;
            return false;
        }
        return true;
    }

    public boolean areThereNoTextSetsPresent(String spaceKey) {
        for (TextSetEntity textSetEntity : (TextSetEntity[])this.ao.find(TextSetEntity.class)) {
            if (!(!spaceKey.isEmpty() ? spaceKey.equals(textSetEntity.getSpaceKey()) : textSetEntity.getSpaceKey() == null || textSetEntity.getSpaceKey().equals(spaceKey))) continue;
            return false;
        }
        return true;
    }

    private void updateLozengeEntity(DropdownSet<LozengeOption> dropdownSet, String spaceKey, LozengeSetEntity existingEntity) {
        LozengeOptionEntity[] lozengeOptionEntities;
        LozengeOptionEntity[] optionsArray;
        existingEntity.setSpaceKey(spaceKey);
        existingEntity.setSetId(dropdownSet.getId());
        existingEntity.setSetName(dropdownSet.getName());
        existingEntity.save();
        for (LozengeOptionEntity optionEntity : optionsArray = existingEntity.getOptionsArray()) {
            this.ao.delete(new RawEntity[]{optionEntity});
        }
        for (LozengeOptionEntity lozengeOptionEntity : lozengeOptionEntities = this.lozengeEntityConverter.convertToEntity(dropdownSet.getOptionsList(), existingEntity, this.ao)) {
            lozengeOptionEntity.save();
        }
        log.info("Updating Easy Dropdown Menu Set with name: " + dropdownSet.getName() + " and id: " + dropdownSet.getId());
    }

    private void updateTextEntity(DropdownSet<TextOption> dropdownSet, String spaceKey, TextSetEntity existingEntity) {
        TextOptionEntity[] textOptionEntities;
        TextOptionEntity[] optionsArray;
        existingEntity.setSpaceKey(spaceKey);
        existingEntity.setSetId(dropdownSet.getId());
        existingEntity.setSetName(dropdownSet.getName());
        existingEntity.save();
        for (TextOptionEntity optionEntity : optionsArray = existingEntity.getOptionsArray()) {
            this.ao.delete(new RawEntity[]{optionEntity});
        }
        for (TextOptionEntity textOptionEntity : textOptionEntities = this.textEntityConverter.convertToEntity(dropdownSet.getOptionsList(), existingEntity, this.ao)) {
            textOptionEntity.save();
        }
        log.info("Updating Easy Dropdown Menu Set with name: " + dropdownSet.getName() + " and id: " + dropdownSet.getId());
    }

    private LozengeSetEntity getLozengeSetEntity(String id) {
        Object[] lozengeSetEntities = (LozengeSetEntity[])this.ao.find(LozengeSetEntity.class, Query.select().where("SET_ID = ?", new Object[]{id}));
        if (ArrayUtils.isEmpty((Object[])lozengeSetEntities)) {
            return null;
        }
        return lozengeSetEntities[0];
    }

    private TextSetEntity getTextSetEntity(String id) {
        Object[] textSetEntities = (TextSetEntity[])this.ao.find(TextSetEntity.class, Query.select().where("SET_ID = ?", new Object[]{id}));
        if (ArrayUtils.isEmpty((Object[])textSetEntities)) {
            return null;
        }
        return textSetEntities[0];
    }

    private List<LozengeSetEntity> getLozengeSetEntities(String spaceKey) {
        LozengeSetEntity[] LozengeSetEntities = StringUtils.isEmpty((CharSequence)spaceKey) ? (LozengeSetEntity[])this.ao.find(LozengeSetEntity.class, Query.select().where("SPACE_KEY = ? OR SPACE_KEY IS NULL", new Object[]{spaceKey})) : (LozengeSetEntity[])this.ao.find(LozengeSetEntity.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
        return Arrays.asList(LozengeSetEntities);
    }

    private List<TextSetEntity> getTextSetEntities(String spaceKey) {
        TextSetEntity[] TextSetEntities = StringUtils.isEmpty((CharSequence)spaceKey) ? (TextSetEntity[])this.ao.find(TextSetEntity.class, Query.select().where("SPACE_KEY = ? OR SPACE_KEY IS NULL", new Object[]{spaceKey})) : (TextSetEntity[])this.ao.find(TextSetEntity.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
        return Arrays.asList(TextSetEntities);
    }

    private List<DropdownSet<LozengeOption>> getSpaceLozengeSets(String spaceKey) {
        if (StringUtils.isEmpty((CharSequence)spaceKey)) {
            return new ArrayList<DropdownSet<LozengeOption>>();
        }
        return this.getLozengeSetsSpaceOrGlobal(spaceKey);
    }

    private List<DropdownSet<LozengeOption>> getGlobalLozengeSets() {
        return this.getLozengeSetsSpaceOrGlobal("");
    }

    private List<DropdownSet<TextOption>> getSpaceTextSets(String spaceKey) {
        if (StringUtils.isEmpty((CharSequence)spaceKey)) {
            return new ArrayList<DropdownSet<TextOption>>();
        }
        return this.getTextSetsSpaceOrGlobal(spaceKey);
    }

    private List<DropdownSet<TextOption>> getGlobalTextSets() {
        return this.getTextSetsSpaceOrGlobal("");
    }
}

