/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.configui.PermittedGroupsCollector;
import eps.focuspro.edm.persistence.EdmCopyService;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import eps.focuspro.edm.persistence.update.SetUpdater;
import eps.focuspro.license.LicenseStatus;
import eps.focuspro.license.LicenseValidator;
import eps.focuspro.rest.dtos.CopiedSetDto;
import java.util.ArrayList;
import java.util.List;

public class EdmCopyServiceImpl
implements EdmCopyService {
    private final SetEntityAccessor setEntityAccessor;
    private final SetUpdater setUpdater;
    private final EdmSettingsManager edmSettingsManager;
    private final PermittedGroupsCollector permittedGroupsCollector;
    private final LicenseValidator licenseValidator;

    public EdmCopyServiceImpl(SetEntityAccessor setEntityAccessor, SetUpdater setUpdater, EdmSettingsManager edmSettingsManager, PermittedGroupsCollector permittedGroupsCollector, LicenseValidator licenseValidator) {
        this.setEntityAccessor = setEntityAccessor;
        this.setUpdater = setUpdater;
        this.edmSettingsManager = edmSettingsManager;
        this.permittedGroupsCollector = permittedGroupsCollector;
        this.licenseValidator = licenseValidator;
    }

    @Override
    public List<CopiedSetDto> copyEdmSets(String sourceSpaceKey, String targetSpaceKey) {
        if (this.licenseValidator.validatePluginLicense().equals((Object)LicenseStatus.VALID)) {
            List<DropdownSet<TextOption>> textSets = this.setEntityAccessor.getTextSetsSpaceOrGlobal(sourceSpaceKey);
            List<DropdownSet<LozengeOption>> lozengeSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(sourceSpaceKey);
            ArrayList<CopiedSetDto> copiedSets = new ArrayList<CopiedSetDto>();
            textSets.forEach(textSet -> {
                String newId = this.setUpdater.createTextSet(textSet.getName(), null, targetSpaceKey, textSet.getOptionsList());
                copiedSets.add(new CopiedSetDto(textSet.getId(), newId));
            });
            lozengeSets.forEach(lozengeSet -> {
                String newId = this.setUpdater.createStatusSet(lozengeSet.getName(), null, targetSpaceKey, lozengeSet.getOptionsList());
                copiedSets.add(new CopiedSetDto(lozengeSet.getId(), newId));
            });
            return copiedSets;
        }
        return List.of();
    }

    @Override
    public List<String> copySpacePermissions(String sourceSpaceKey, String targetSpaceKey) {
        if (this.licenseValidator.validatePluginLicense().equals((Object)LicenseStatus.VALID)) {
            EdmSpaceSettings edmSpaceSettings = new EdmSpaceSettings(targetSpaceKey, this.edmSettingsManager.getSpaceSettings(sourceSpaceKey).getCssClasses(), this.permittedGroupsCollector.getGroupsFromSpaceSettings(sourceSpaceKey));
            this.edmSettingsManager.saveSpaceSettings(edmSpaceSettings);
            return edmSpaceSettings.getPermittedGroups();
        }
        return List.of();
    }
}

