/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.dropdown.dtos;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import eps.focuspro.dropdown.dtos.DropdownDto;
import eps.focuspro.macros.EdmMacroUtils;
import java.util.Map;

public class DropdownDtoCreator {
    private static final String PARAMETER_MAP_MACRODEFINITION = "macroDefinition";

    public DropdownDto create(Map<String, String> parameters, ConversionContext conversionContext, boolean isPredefined) {
        long pageId = this.getPageId(conversionContext);
        String spaceKey = this.getSpaceKey(conversionContext);
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty(PARAMETER_MAP_MACRODEFINITION);
        String outputType = conversionContext.getOutputType();
        boolean isExport = !"display".equals(outputType) && !"feed".equals(outputType);
        return this.computeDropdownDto(pageId, spaceKey, macroDefinition, parameters, isExport, isPredefined);
    }

    private long getPageId(ConversionContext conversionContext) {
        ContentEntityObject contentEntityObject = conversionContext.getEntity();
        return contentEntityObject == null ? 0L : contentEntityObject.getId();
    }

    private String getSpaceKey(ConversionContext conversionContext) {
        ContentEntityObject contentEntityObject = conversionContext.getEntity();
        return contentEntityObject == null ? "" : conversionContext.getSpaceKey();
    }

    private DropdownDto computeDropdownDto(long pageId, String spaceKey, MacroDefinition macroDefinition, Map<String, String> parameters, boolean isExport, boolean isPredefined) {
        String macroId = EdmMacroUtils.getMacroId(macroDefinition);
        return new DropdownDto(parameters, isPredefined, macroId, pageId, spaceKey, isExport);
    }
}

