import {createUsageWindow, getCssClasses, getGroupNames, succesInsertCssHtml} from "./edm-config-functions";


export const showRememberToSaveCss = function (saveReminder) {
    saveReminder.fadeIn('slow', function () {
        saveReminder.delay(2200).fadeOut();
    });
};

AJS.toInit(function () {

    const showMacroUsageHtml = function (resp, setName) {
        return Confluence.Sap.Configure.getMacroUsageDisplay({
            titleMapList: resp,
            contextPath: AJS.params.baseUrl,
            auiVersion: parseInt(AJS.version),
            setName: setName,
        });
    };


    const getHtmlStringFromGroups = function (groups) {
        return Confluence.Sap.Space.Groups.configGroups({
            dropdown_groups: groups
        });
    };

    const getHtmlStringFromCss = function (cssClasses) {
        return Confluence.Sap.Configure.css({
            css_classes: cssClasses
        });
    };

    // ----------------Groups-Dropdown-------------------------
    const convertToGroupSelectObject = function (valueArray) {
        var groups = [];
        for (var i = 0, length = valueArray.length; i < length; i++) {
            if (typeof valueArray[i] === 'string') {
                groups.push({id: valueArray[i], text: valueArray[i]});
            }
        }
        return groups;
    };


    const setGroupDropdown = resp => {
        AJS.$('#edm-groups-dropdown').auiSelect2({
            multiple: false,
            allowClear: true,
            data: convertToGroupSelectObject(resp)
        });
    };


    AJS.$('#edm-groups-dropdown').each(function () {
        Edm.Rest.get(AJS.params.contextPath + '/rest/edm/1.0/edm/groups/allWritableNames', setGroupDropdown);
    });

    const successInsertGroupsHtml = function (htmlString) {
        AJS.$('#groupHtmlToReplace').replaceWith(htmlString);
        Edm.Rest.get(AJS.params.contextPath + '/rest/edm/1.0/edm/groups/allWritableNames', setGroupDropdown);
        showRememberToSaveCss(AJS.$('#edm-groups-save-reminder'));
    };

    AJS.$(document).on('click', '#edm-add-group-button', function () {
        var groupToAdd = AJS.$('#edm-groups-dropdown').val();
        if (groupToAdd.length > 0) {
            var groupNames = getGroupNames();
            groupNames.push(groupToAdd);
            var htmlString = getHtmlStringFromGroups(groupNames);
            successInsertGroupsHtml(htmlString);
        }
    });

    AJS.$(document).on('click', '.edm-delete-row-group', function () {
        if (AJS.Meta.get('access-mode') !== 'READ_ONLY') {
            const groupToRemove = this.getAttribute('data-edm-group');
            const groupNames = getGroupNames();
            const updatedGroupNames = groupNames.filter(group => group !== groupToRemove);
            const htmlString = getHtmlStringFromGroups(updatedGroupNames);
            successInsertGroupsHtml(htmlString);
        }
    });

    // ----------------Css-Classes-Table------------------------
    AJS.$(document).on('click', '#edm-add-css-button', function () {
        var cssToAdd = AJS.$('#edm-css-addValue').val();
        if (AJS.Meta.get('access-mode') !== 'READ_ONLY') {
            if (cssToAdd.length > 0) {
                var classes = getCssClasses();
                classes.push(cssToAdd);
                var htmlString = getHtmlStringFromCss(classes);
                succesInsertCssHtml(htmlString);
            }
        } else {
            Edm.Flag.readOnlyModeFlag()
        }
    });

    AJS.$(document).on('click', '.edm-delete-row-css', function () {
        if (AJS.Meta.get('access-mode') !== 'READ_ONLY') {
            const cssToRemove = this.getAttribute('data-edm-css');
            const cssClasses = getCssClasses();
            const updatedCssClasses = cssClasses.filter(cssClass => cssClass !== cssToRemove);
            const htmlString = getHtmlStringFromCss(updatedCssClasses);
            succesInsertCssHtml(htmlString);
        }
    });

    AJS.$(document).on('click', '.show-old-css', function () {
        AJS.$('#edm-old-css').fadeIn('slow', function () {
            AJS.$('#edm-old-css').delay(5000).fadeOut();
        });
    });

    AJS.$(document).on('click', '.edm-used-dropdowns', function () {
        const setId = this.getAttribute("data-edm-set-id");
        const setName = this.getAttribute('data-edm-set-name-usage');

        Edm.Rest.post(AJS.params.baseUrl + "/rest/edm/1.0/cql/search/allUsedDropdownSets/", ({setId: setId}), function (resp) {
            const htmlString = showMacroUsageHtml(resp, setName);
            createUsageWindow(htmlString);
        });
    });
});
