import {
    createDataMigrationWindow,
    getCssClasses, getCssDefaults, getDataMigrationDialogHtml,
    getEditModeTextNoValue,
    getEdmAllowAnonymous, getEdmAllowWithoutEditPermission,
    getGroupNames,
    getSuppressNotifications
} from "./edm-config-functions";
import {remoteAbstractTask} from "./task/remoteAbstractTask";

AJS.toInit(function () {

    // ----------------SomeStuffIDon'tKnowForSure-BLUBBER-------------------------
    if (AJS.$("#edm-config-div").length >= 1) {
        Edm.Rest.get(AJS.params.baseUrl + "/rest/edm/1.0/edm/license/valid", function (resp) {
            if (resp !== undefined && resp !== null && resp !== "") {
                Edm.Flag.newFlag("warning", resp);
            }
        });
    }

//----------------------------SAVE_BUTTON----------------------------------->>
    const getConfigSaveData = function () {
        return {
            permittedGroupNames: JSON.stringify(getGroupNames()),
            editModeTextNoValue: getEditModeTextNoValue(),
            cssClasses: JSON.stringify(getCssClasses()),
            isSuppressNotifications: getSuppressNotifications(),
            isEdmAllowAnonymous: getEdmAllowAnonymous(),
            isEdmAllowWithoutEditPermission: getEdmAllowWithoutEditPermission(),
            cssDefaults: getCssDefaults()
        }
    };

    AJS.$('#edm-config-servlet').submit(function () {
        var url = AJS.params.baseUrl + "/rest/edm/1.0/global/save/configSettings";
        Edm.Rest.post(url, getConfigSaveData(), function () {
            Edm.Flag.spaceSettingsSuccessFlag();
        });
        return false;
    });

//    ---------------- Migration Button --------------------------------->>
    $('#edm-migrate-dropdowns-version-1').on('click', function () {
        this.disabled = true;
        var url = AJS.params.baseUrl + "/rest/edm/1.0/edm-task/migrateDropDowns";
        remoteAbstractTask(url, (resp) => {
            $("#edm-progress-bar-text").text(resp.successMessage);
        }, () => console.log("Failed to migrate all macros"));
    });

//    --------------Reindex Button ---------------------------------->>
    $('#edm-reindex-dropdown-button').on('click', function () {
        this.disabled = true;
        var url = AJS.params.baseUrl + "/rest/edm/1.0/global/reindexAllPages";
        Edm.Rest.get(url, (resp) => Edm.Flag.newFlag("success", "Added " + resp.pageCount + " pages to the reindex queue"));
    });
    // ---------------- Data Migration ------------------------->>
    $('#edm-open-data-migration-dialog').on('click', function () {
        const isReadOnlyModeActive = AJS.Meta.get('access-mode') === 'READ_ONLY';
        const allSpaces = JSON.parse(AJS.$('#edm-data-migration-input').val());
        const htmlString = getDataMigrationDialogHtml(isReadOnlyModeActive, allSpaces);
        createDataMigrationWindow(htmlString);
    });

    $(document).on('click', '#edm-export-sets-button', function () {
        const spaceKeys = [];
        $('.edm-space-checkbox').each((index, checkbox) => {
            if (checkbox.checked) {
                spaceKeys.push(checkbox.value);
            }
        });
        Edm.Rest.getDataJson({spaceKeys}, (resp) => {
            downloadAsFile(resp);
        });
    });

    $(document).on('click', '#edm-checkbox-select-all', function () {
        $('.edm-space-checkbox').each((index, checkbox) => {
            checkbox.checked = true;
        });
    });

    $(document).on('click', '#edm-checkbox-deselect-all', function () {
        $('.edm-space-checkbox').each((index, checkbox) => {
            checkbox.checked = false;
        });
    });

    const downloadAsFile = function (json) {
        const blob = new Blob([JSON.stringify(json)], {type: 'application/json'});
        const elem = window.document.createElement('a');
        elem.href = window.URL.createObjectURL(blob);
        elem.download = 'EdmSetExport.json';
        document.body.appendChild(elem);
        elem.click();
        document.body.removeChild(elem);
    };

    $(document).on('click', '#edm-import-sets-button', function () {
        const fileReader = new FileReader();
        const file = AJS.$('#edm-data-migration-file-input')[0].files[0];
        fileReader.readAsText(file, 'UFT-8');
        fileReader.onload = (onLoadEvent) => {
            Edm.Rest.importDataJson(JSON.parse(onLoadEvent.target.result));
        }
        $('#edm-data-migration-file-input').val('');
    });
});
