import {statusEditorColorDropdownObject} from "./edm-select2";
import {showRememberToSaveCss} from "./edm-universal-config";

const createWarningDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-delete-warning-config\" class=\"aui-dialog2 aui-dialog2-medium aui-layer\" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-delete-warning-config").length === 0) {
        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }

        AJS.dialog2("#edm-delete-warning-config").on("hide", function () {
            AJS.$("#edm-delete-warning-config").html("");
        });
    }
};

//----------------------Editor-Div-Creator-------------------------------------------------------------------------------
const createUniversalStatusDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-status-dialog-config\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-status-dialog-config").length === 0) {

        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-status-dialog-config").on("hide", function () {
            AJS.$("#edm-status-dialog-config").html("");
        });
    }
};

const createUniversalHistoryDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-history-dialog\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-history-dialog").length === 0) {

        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-history-dialog").on("hide", function () {
            AJS.$("#edm-history-dialog").html("");
        });
    }
};

const createUniversalMacroUsageDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-macro-usage-dialog\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-macro-usage-dialog").length === 0) {

        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-macro-usage-dialog").on("hide", function () {
            AJS.$("#edm-macro-usage-dialog").html("");
        });
    }
};

const createUniversalTextDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-text-dialog-config\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-text-dialog-config").length === 0) {
        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-text-dialog-config").on("hide", function () {
            AJS.$("#edm-text-dialog-config").html("");
        });
    }
};

export const createUniversalDataMigrationDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-data-migration-dialog\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-data-migration-dialog").length === 0) {

        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-data-migration-dialog").on("hide", function () {
            AJS.$("#edm-data-migration-dialog").html("");
        });
    }
};

//---------------------------------check if new SetNameValid----------------------------------------------------------------------------
export const checkIfSetNameValid = function (newSetName, elements) {
    let valid = true;
    if (!newSetName.length >= 1) {
        valid = false;
    }
    $(elements).each(function (index, element) {
        if ($(element).text() === newSetName) {
            valid = false;
        }
    });
    return valid;
};

//----------------------------------------------------------------------------
export const getDataMigrationDialogHtml = function (isReadOnlyModeActive, allSpaces) {
    return Confluence.Sap.Configure.DataMigration.Dialog.doGet({
        isReadOnlyModeActive: isReadOnlyModeActive,
        auiVersion: parseInt(AJS.version),
        spaces: allSpaces
    });
};

export const replaceLozengeHtmlWithResponse = function (dropdownSetList, htmlGetterFunction) {
    const htmlString = htmlGetterFunction(dropdownSetList);
    AJS.$('#lozengeHtmlToReplace').replaceWith(htmlString);
};

export const replaceTextHtmlWithResponse = function (dropdownSetList, htmlGetterFunction) {
    const htmlString = htmlGetterFunction(dropdownSetList);
    AJS.$('#textHtmlToReplace').replaceWith(htmlString);
};

export const getCssDefaults = function () {
    const map = {};
    map["editMode"] = AJS.$('#edm-css-editMode').val();
    map["non-predefined"] = AJS.$('#edm-css-non-predefined').val();
    map["predefined"] = AJS.$('#edm-css-predefined').val();
    return map;
};

export const getCssClasses = function () {
    const classes = [];
    AJS.$('.css-class').each(function () {
        const css = this.textContent;
        classes.push(css);
    });
    return classes;
};

export const succesInsertCssHtml = function (htmlString) {
    AJS.$('#cssHtmlToReplace').replaceWith(htmlString);
    showRememberToSaveCss(AJS.$('#edm-css-save-reminder'));
};

export const getGroupNames = function () {
    const groups = [];
    AJS.$('.group-name').each(function () {
        const group = this.textContent;
        groups.push(group);
    });
    return groups;
};

// ----------------GET-THEM-BOOLEANS-FROM-CHECKBOXES------------------------
export const getSuppressNotifications = function () {
    return AJS.$('#edm-suppress-notifications').is(':checked');
};

export const getEdmAllowAnonymous = function () {
    return AJS.$('#edm-allow-anonymous').is(':checked');
};

export const getEdmAllowWithoutEditPermission = function () {
    return AJS.$('#edm-allow-without-edit-permissions').is(':checked');
};

// ----------------GET-EDIT-MODE-TEXT_NO_VALUE------------------------
export const getEditModeTextNoValue = function () {
    return AJS.$('#edm-edit-mode-text-no-value').val();
};

const getDeleteWarningHtml = function (setId, buttonId, setName) {
    return Confluence.Sap.Configure.Lozenge.deleteWarning({
        set_id: setId,
        button_id: buttonId,
        auiVersion: parseInt(AJS.version),
        setName: setName,
    });
};

const convertColorKeyToRealColorWithoutSubtle = function (colorKey) {
    let realColors;
    switch (colorKey) {
        case "green":
            realColors = ({
                background: "#14892c",
                color: "white",
                border_color: "#14892c"
            });
            break;
        case "red":
            realColors = ({
                background: "#d04437",
                color: "white",
                border_color: "#d04437"
            });
            break;
        case "yellow":
            realColors = ({
                background: "#ffd351",
                color: "#253858",
                border_color: "#ffd351"
            });
            break;
        case "blue":
            realColors = ({
                background: "#4a6785",
                color: "white",
                border_color: "#4a6785"
            });
            break;
        case "brown":
            realColors = ({
                background: "#815b3a",
                color: "white",
                border_color: "#815b3a"
            });
            break;
        default:
            realColors = ({
                background: "#cccccc",
                color: "#333333",
                border_color: "#cccccc"
            });
    }
    return realColors;
};

export const getColorFromDropdown = function (colorElement) {
    const colorKey = AJS.$(colorElement).val();
    return convertColorKeyToRealColorWithoutSubtle(colorKey);
};

export const setColorinInputField = function (colorsFromDropdown, subtle, inputField) {
    let finishcolor = colorsFromDropdown;
    if (subtle === true || subtle === "true") {
        finishcolor = getColorsWithSubtle(colorsFromDropdown);
    }
    $(inputField).css("background-color", finishcolor.background);
    $(inputField).css("color", finishcolor.color);
    $(inputField).css("border-color", finishcolor.border_color);
};

const createDropdownForColorSelection = function (inputField) {
    AJS.$(inputField).auiSelect2({
        dropdownCssClass: "edm-config-dropdownClass",
        containerCssClass: "dropdowncontainer-config-css",
        multiple: false,
        allowClear: true,
        data: statusEditorColorDropdownObject(),
        templateResult: statusEditorColorDropdownObject(),
        escapeMarkup: function (m) {
            return m;
        }
    });
};

export const checkForSubtleFromColorElement = function (colorElement) {
    return AJS.$(colorElement).closest('.edm-editor-status-listelement').find('.edm-option-subtle-checkbox').is(':checked');
};

const createThemColorDropdowns = function () {
    AJS.$('.edm-option-color-dropdown').each(function () {
        createDropdownForColorSelection(this);
        const colorsFromDropdown = getColorFromDropdown(this);
        const subtle = checkForSubtleFromColorElement(this);
        const inputField = $(this).closest('.edm-editor-status-listelement').find('.edm-option-field-input');
        setColorinInputField(colorsFromDropdown, subtle, inputField);
    });
};

export const resizable = function (el, factor) {
    const int = Number(factor) || 7.7;

    function resize() {
        el.style.width = ((el.value.length + 1) * int) + 'px'
    }

    const e = 'keyup,keypress,focus,blur,change'.split(',');
    for (let i in e) el.addEventListener(e[i], resize, false);
    resize();
};

const getColorsWithSubtle = function (colorsWithoutSubtle) {
    const color = colorsWithoutSubtle.background;
    return ({
        color: color,
        background: "white",
        border_color: color
    });
};

export const createStatusTemplateWindow = function (dropdownSet, isReadOnlyModeActive, htmlGetterFunction) {
    createUniversalStatusDialogDivIfNeeded();
    const htmlString = htmlGetterFunction(dropdownSet, isReadOnlyModeActive);
    AJS.$("#edm-status-dialog-config").html(htmlString);
    AJS.dialog2("#edm-status-dialog-config").show();
    createThemColorDropdowns();
    AJS.$('.edm-option-field-input').each(function () {
        resizable(this, 7);
    });
    if (!isReadOnlyModeActive) {
        AJS.$('.edm-set-editor-list').sortable();
    }
};

export const createHistoryWindow = function (statusHistory, htmlFunction) {
    createUniversalHistoryDialogDivIfNeeded();
    const htmlString = htmlFunction(statusHistory);
    AJS.$("#edm-history-dialog").html(htmlString);
    AJS.dialog2("#edm-history-dialog").show();
};

export const createUsageWindow = function (htmlString) {
    createUniversalMacroUsageDialogDivIfNeeded();
    AJS.$("#edm-macro-usage-dialog").html(htmlString);
    AJS.dialog2("#edm-macro-usage-dialog").show();
};

export const createTextTemplateWindow = function (dropdownSet, isReadOnlyModeActive, htmlGetterFunction) {
    createUniversalTextDialogDivIfNeeded();
    const htmlString = htmlGetterFunction(dropdownSet, isReadOnlyModeActive);
    AJS.$("#edm-text-dialog-config").html(htmlString);
    AJS.dialog2("#edm-text-dialog-config").show();
    AJS.$('.edm-text-field-input').each(function () {
        resizable(this, 7);
    });
    if (!isReadOnlyModeActive) {
        AJS.$('.edm-text-set-editor-list').sortable();
    }
};

export const createDataMigrationWindow = function (htmlString) {
    createUniversalDataMigrationDialogDivIfNeeded();
    AJS.$("#edm-data-migration-dialog").html(htmlString);
    AJS.dialog2("#edm-data-migration-dialog").show();
};

export const createDeleteWarningWindow = function (setId, deleteButtonId, setName) {
    createWarningDialogDivIfNeeded();
    const htmlString = getDeleteWarningHtml(setId, deleteButtonId, setName);
    AJS.$('#edm-delete-warning-config').html(htmlString);
    AJS.dialog2("#edm-delete-warning-config").show();
};

export const generateUUID = function () {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        // noinspection EqualityComparisonWithCoercionJS copy pasted from Stack Overflow
        const r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
};

//-----------------------------SET_EDITOR----------------------------------->>>
const readOutValuesOfStatusElement = function (element) {
    const optionId = AJS.$(element).attr('id');
    const optionName = AJS.$(element).find('.edm-option-field-input').val();
    const color = AJS.$(element).find('.edm-option-color-dropdown-div').find('input.edm-option-color-dropdown').val();
    const subtle = AJS.$(element).find('.edm-option-subtle-checkbox').is(':checked');
    return ({
        id: optionId,
        name: optionName,
        color: color,
        subtle: subtle
    });
};

const readOutValuesOfTextElement = function (element) {
    const optionId = AJS.$(element).attr('id');
    const optionName = AJS.$(element).find('.edm-text-field-input').val();
    return ({
        id: optionId,
        name: optionName
    });
};

export const getSpaceKeyContext = function () {
    let spaceKey = "";
    if (AJS.params.spaceKey) {
        spaceKey = AJS.params.spaceKey
    }
    return spaceKey;
}

export const getCompleteStatusSetData = function () {
    let spaceKey = getSpaceKeyContext();
    const setName = AJS.$('.edm-status-editor-name').val();
    const setId = AJS.$('.edm-set-editor-list').attr('id');
    const optionsList = [];
    const elements = AJS.$('.edm-set-editor-list').find('.edm-editor-status-listelement');
    let i = 0;
    const len = elements.length;
    for (; i < len; i++) {
        const option = readOutValuesOfStatusElement(elements[i]);
        if (option.name.length >= 1) {
            optionsList.push(option);
        } else {
            Edm.Flag.someOptionsGotDeletedCauseInvalidName();
        }
    }
    return createCompleteSetDataObject(spaceKey, setId, setName, optionsList);
};

/**
 *
 * @param spaceKey empty for global
 * @param setId can be null in case of creation
 * @param setName
 * @param optionsList array of options
 */
export const createCompleteSetDataObject = function (spaceKey, setId, setName, optionsList) {
    return ({
        spaceKey: spaceKey,
        id: setId,
        name: setName,
        optionsList: optionsList
    });
}

export const getCompleteTextSetData = function () {
    let spaceKey = "";
    if (AJS.params.spaceKey) {
        spaceKey = AJS.params.spaceKey
    }
    const setName = AJS.$('.edm-set-editor-name').val();
    const setId = AJS.$('.edm-text-set-editor-list').attr('id');
    const optionsList = [];
    const elements = AJS.$('.edm-text-set-editor-list').find('.edm-editor-text-listelement');
    let i = 0;
    const len = elements.length;
    for (; i < len; i++) {
        const option = readOutValuesOfTextElement(elements[i]);
        if (option.name.length >= 1) {
            optionsList.push(option);
        } else {
            Edm.Flag.someOptionsGotDeletedCauseInvalidName();
        }
    }
    return ({
        spaceKey: spaceKey,
        id: setId,
        name: setName,
        optionsList: optionsList
    });
};

const chooseRightNameAndChange = function (setId, setName, nameElements) {
    for (let i = 0; i < nameElements.length; i++) {
        if (setId === AJS.$(nameElements[i]).prop('id')) {
            AJS.$(nameElements[i]).text(setName);
        }
    }
};

export const setTextNameOnConfigMainPage = function (setName, setId) {
    const nameElements = AJS.$('.edm-text-key-field');
    chooseRightNameAndChange(setId, setName, nameElements);
};

export const setStatusNameOnConfigMainPage = function (setName, setId) {
    const nameElements = AJS.$('.edm-status-key-field');
    chooseRightNameAndChange(setId, setName, nameElements);
};

export const deleteStatusNameFromPage = function (setId) {
    AJS.$('td#' + setId).closest('.statusInputs').remove();
};

export const deleteTextNameFromPage = function (setId) {
    AJS.$('td#' + setId).closest('.textInputs').remove();
};

export const makeDropdownOfClonedElementWork = function (clonedElement) {
    createDropdownForColorSelection(clonedElement.find('input.edm-option-color-dropdown'));
    const elements = AJS.$(clonedElement).find('.edm-option-color-dropdown');
    AJS.$(elements[0]).remove();
};

//____________________Restore Options____________________
export const getStatusRestoreButtonData = function (button) {
    let spaceKey = "";
    if (AJS.params.spaceKey) {
        spaceKey = AJS.params.spaceKey;
    }

    return ({
        setId: $('.edm-history-table').attr('id'),
        optionId: button.getAttribute('data-edm-option-id'),
        optionName: button.getAttribute('data-edm-option-name'),
        optionColor: button.getAttribute('data-edm-option-color'),
        optionSubtle: button.getAttribute('data-edm-option-subtle'),
        spaceKey: spaceKey
    });
};

export const getTextRestoreButtonData = function (button) {
    let spaceKey = "";
    if (AJS.params.spaceKey) {
        spaceKey = AJS.params.spaceKey;
    }

    return ({
        setId: $('.edm-history-table').attr('id'),
        optionId: button.getAttribute('data-edm-option-id'),
        optionName: button.getAttribute('data-edm-option-name'),
        spaceKey: spaceKey
    });
};

export const showFlagFromRestoreResponse = function (resp, button) {
    if (resp === "Restored Succesfully") {
        $(button).replaceWith('<div class="edm-history-element-event-new">Restored</div>');
        Edm.Flag.restoredOptionSuccessFully();
    }
};

