/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.search.core;

import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.search.v2.query.WildcardTextFieldQuery;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultProvider {
    private static final Logger log = LoggerFactory.getLogger(SearchResultProvider.class);
    private final SearchManager searchManager;

    public SearchResultProvider(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    public List<SearchResult> searchMacroName(String macroName) {
        MacroUsageQuery searchQuery = new MacroUsageQuery(macroName);
        ContentSearch contentSearch = new ContentSearch((SearchQuery)searchQuery, null, 0, 100000000);
        return this.doContentSearch(contentSearch);
    }

    public List<SearchResult> searchFieldName(String fieldName) {
        WildcardTextFieldQuery query = new WildcardTextFieldQuery(fieldName, "*", BooleanOperator.AND);
        ModifiedSort searchSort = new ModifiedSort(SearchSort.Order.DESCENDING);
        ContentSearch contentSearch = new ContentSearch((SearchQuery)query, (SearchSort)searchSort, 0, 1000000);
        return this.doContentSearch(contentSearch);
    }

    private List<SearchResult> doContentSearch(ContentSearch contentSearch) {
        try {
            SearchResults search = this.searchManager.search((ISearch)contentSearch);
            if (search != null) {
                return search.getAll();
            }
        }
        catch (InvalidSearchException e) {
            log.warn("Exception occured getting SearchResults", (Throwable)e);
        }
        return new ArrayList<SearchResult>();
    }
}

