/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration.reflectors;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.history.historyObjects.OptionHistoryChange;
import eps.focuspro.history.historyObjects.SetHistory;
import eps.focuspro.migration.reflectors.ReflectorHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextReflector {
    private ReflectorHelper reflectorHelper;
    private static final Logger log = LoggerFactory.getLogger(TextReflector.class);

    public TextReflector(ReflectorHelper reflectorHelper) {
        this.reflectorHelper = reflectorHelper;
    }

    public List<SetHistory<TextOption>> reflectTextSetHistory(List<Object> setHistories) {
        ArrayList<SetHistory<TextOption>> reflectedSetHistories = new ArrayList<SetHistory<TextOption>>();
        for (Object setHistory : setHistories) {
            try {
                ArrayList optionHistoryChangeList = this.reflectorHelper.getOptionHistoryChangeList(setHistory);
                ArrayList reflectedOptionHistoryChangeList = new ArrayList();
                for (Object optionHistoryChange : optionHistoryChangeList) {
                    Object oldOption = this.reflectorHelper.getOldOptionOfHistoryChange(optionHistoryChange);
                    Object newOption = this.reflectorHelper.getNewOptionOfHistoryChange(optionHistoryChange);
                    TextOption oldTextOption = this.reflectTextOption(oldOption);
                    TextOption newTextOption = this.reflectTextOption(newOption);
                    reflectedOptionHistoryChangeList.add(new OptionHistoryChange<TextOption>(oldTextOption, newTextOption, this.reflectorHelper.getDateTimeOfHistoryChange(optionHistoryChange), this.reflectorHelper.getUsernameOfHistoryChange(optionHistoryChange), this.reflectorHelper.getHistoryEvent(optionHistoryChange)));
                }
                reflectedSetHistories.add(new SetHistory(this.reflectorHelper.getSetIdFromSetHistory(setHistory), reflectedOptionHistoryChangeList));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Something went wrong while reflecting", (Throwable)e);
            }
        }
        return reflectedSetHistories;
    }

    public List<DropdownSet<TextOption>> reflectTextDropdowns(List<DropdownSet<TextOption>> list) {
        ArrayList<DropdownSet<TextOption>> dropdownSets = new ArrayList<DropdownSet<TextOption>>();
        for (DropdownSet<TextOption> dropdownSetObject : list) {
            try {
                ArrayList optionObjectsList = this.reflectorHelper.getOptionsListFromObject(dropdownSetObject);
                ArrayList<TextOption> textOptionList = this.reflectTextOptionsList(optionObjectsList);
                dropdownSets.add(new DropdownSet<TextOption>(this.reflectorHelper.getSetIdFromDropdownSet(dropdownSetObject), this.reflectorHelper.getSetNameFromDropdownSet(dropdownSetObject), textOptionList));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Something went wrong while reflecting", (Throwable)e);
            }
        }
        return dropdownSets;
    }

    private ArrayList<TextOption> reflectTextOptionsList(List<Object> optionsList) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<TextOption> textOptionList = new ArrayList<TextOption>();
        for (Object option : optionsList) {
            textOptionList.add(this.reflectTextOption(option));
        }
        return textOptionList;
    }

    private TextOption reflectTextOption(Object option) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return new TextOption(this.reflectorHelper.getSuperOptionIdFromObject(option), this.reflectorHelper.getSuperOptionNameFormObject(option));
    }
}

