/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration.reflectors;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.history.historyObjects.OptionHistoryChange;
import eps.focuspro.history.historyObjects.SetHistory;
import eps.focuspro.migration.reflectors.ReflectorHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LozengeReflector {
    private final ReflectorHelper reflectorHelper;
    private static final Logger log = LoggerFactory.getLogger(LozengeReflector.class);

    public LozengeReflector(ReflectorHelper reflectorHelper) {
        this.reflectorHelper = reflectorHelper;
    }

    public List<SetHistory<LozengeOption>> reflectLozengeSetHistory(List<Object> setHistories) {
        ArrayList<SetHistory<LozengeOption>> reflectedSetHistories = new ArrayList<SetHistory<LozengeOption>>();
        for (Object setHistory : setHistories) {
            try {
                ArrayList optionHistoryChangeList = this.reflectorHelper.getOptionHistoryChangeList(setHistory);
                ArrayList reflectedOptionHistoryChangeList = new ArrayList();
                for (Object optionHistoryChange : optionHistoryChangeList) {
                    Object oldOption = this.reflectorHelper.getOldOptionOfHistoryChange(optionHistoryChange);
                    Object newOption = this.reflectorHelper.getNewOptionOfHistoryChange(optionHistoryChange);
                    LozengeOption oldLozengeOption = this.reflectLozengeOption(oldOption);
                    LozengeOption newLozengeOption = this.reflectLozengeOption(newOption);
                    reflectedOptionHistoryChangeList.add(new OptionHistoryChange<LozengeOption>(oldLozengeOption, newLozengeOption, this.reflectorHelper.getDateTimeOfHistoryChange(optionHistoryChange), this.reflectorHelper.getUsernameOfHistoryChange(optionHistoryChange), this.reflectorHelper.getHistoryEvent(optionHistoryChange)));
                }
                reflectedSetHistories.add(new SetHistory(this.reflectorHelper.getSetIdFromSetHistory(setHistory), reflectedOptionHistoryChangeList));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Error while reflecting Lozenges", (Throwable)e);
            }
        }
        return reflectedSetHistories;
    }

    public List<DropdownSet<LozengeOption>> reflectLozengeDropdownSets(List<DropdownSet<LozengeOption>> list) {
        ArrayList<DropdownSet<LozengeOption>> dropdownSets = new ArrayList<DropdownSet<LozengeOption>>();
        for (DropdownSet<LozengeOption> dropdownSetObject : list) {
            try {
                ArrayList optionObjectsList = this.reflectorHelper.getOptionsListFromObject(dropdownSetObject);
                ArrayList<LozengeOption> lozengeOptionList = this.reflectLozengeOptionsList(optionObjectsList);
                dropdownSets.add(new DropdownSet<LozengeOption>(this.reflectorHelper.getSetIdFromDropdownSet(dropdownSetObject), this.reflectorHelper.getSetNameFromDropdownSet(dropdownSetObject), lozengeOptionList));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Error while reflecting Lozenges", (Throwable)e);
            }
        }
        return dropdownSets;
    }

    private ArrayList<LozengeOption> reflectLozengeOptionsList(List<Object> optionsList) {
        ArrayList<LozengeOption> lozengeOptionList = new ArrayList<LozengeOption>();
        for (Object option : optionsList) {
            try {
                lozengeOptionList.add(this.reflectLozengeOption(option));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Error while reflecting Lozenges", (Throwable)e);
            }
        }
        return lozengeOptionList;
    }

    private LozengeOption reflectLozengeOption(Object option) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getColor = option.getClass().getDeclaredMethod("getColor", new Class[0]);
        Method getSubtle = option.getClass().getDeclaredMethod("getSubtle", new Class[0]);
        String color = (String)getColor.invoke(option, new Object[0]);
        boolean subtle = (Boolean)getSubtle.invoke(option, new Object[0]);
        return new LozengeOption(this.reflectorHelper.getSuperOptionIdFromObject(option), this.reflectorHelper.getSuperOptionNameFormObject(option), color, subtle);
    }
}

