/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration.newSetCreator;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.TextOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;

public class TextSetUpdater {
    private final Supplier<String> generateUUID = () -> UUID.randomUUID().toString();
    private final Function<String, TextOption> createSingleTextOption = option -> new TextOption(this.generateUUID.get(), (String)option);
    private final Function<String, List<String>> makeOptionStringToListFunction = oldOptionString -> Arrays.asList(oldOptionString.split("\\s*,\\s*"));
    private final Function<List<String>, ArrayList<TextOption>> createTextOptionList = oldOptionsList -> {
        ArrayList<TextOption> textOptionsList = new ArrayList<TextOption>();
        for (String option : oldOptionsList) {
            textOptionsList.add(this.createSingleTextOption.apply(option));
        }
        return textOptionsList;
    };

    public DropdownSet<TextOption> createNewSet(String setKey, String oldOptionsString) {
        return new DropdownSet<TextOption>(this.generateUUID.get(), setKey, this.createTextOptionList.apply(this.makeOptionStringToListFunction.apply(oldOptionsString)));
    }
}

