/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.configui.DatabaseSettingsManager;
import eps.focuspro.configui.spaceconfig.SpaceSettings;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.daos.Version1MappingsDao;
import eps.focuspro.migration.newSetCreator.TextSetUpdater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class TextSetSettingsConverter {
    private TextSetUpdater textSetUpdater;
    private SpaceSettings spaceSettings;
    public static final String EDM_TEXT_SPACE_SET_MAPPING_KEY = "edm-text-space-set-mapping-key";
    public static final String EDM_TEXT_GLOBAL_SET_MAPPING_KEY = "edm-text-global-set-mapping-key";
    public static final String EDM_TEXT_SPACE_OPTIONS_MAPPING_KEY = "edm-text-space-options-mapping-key";
    public static final String EDM_TEXT_GLOBAL_OPTIONS_MAPPING_KEY = "edm-text-global-options-mapping-key";
    final Supplier<Map<String, String>> createGlobalSettingsSupplier;
    private Version1MappingsDao version1MappingsDao;
    private SetEntityAccessor setEntityAccessor;
    final Function<Map<String, String>, List<DropdownSet<TextOption>>> createNewSets = oldLozengeSets -> {
        ArrayList sets = new ArrayList();
        oldLozengeSets.forEach((key, value) -> sets.add(this.textSetUpdater.createNewSet((String)key, (String)value)));
        return sets;
    };
    final Function<List<DropdownSet<TextOption>>, Map<String, String>> setMappingFunction = dropdownSetList -> {
        HashMap<String, String> setMapping = new HashMap<String, String>();
        for (DropdownSet dropdownSet : dropdownSetList) {
            setMapping.put(dropdownSet.getName().trim(), dropdownSet.getId().trim());
        }
        return setMapping;
    };
    final Function<List<DropdownSet<TextOption>>, Map<String, Map<String, String>>> textOptionsMapping = dropdownSetList -> {
        HashMap<String, Map<String, String>> optionsMapping = new HashMap<String, Map<String, String>>();
        for (DropdownSet dropdownSet : dropdownSetList) {
            optionsMapping.put(dropdownSet.getId().trim(), this.getSingleOptionsMapping(dropdownSet));
        }
        return optionsMapping;
    };
    final Consumer<List<DropdownSet<TextOption>>> globalSetSaver = dropdownSetList -> {
        for (DropdownSet dropdownSet : dropdownSetList) {
            this.setEntityAccessor.saveTextSetUnTransactional(dropdownSet, "");
        }
    };
    BiConsumer<Map<String, String>, Map<String, Map<String, String>>> globalMappingSaver = (setMapping, optionsMapping) -> {
        this.version1MappingsDao.saveSetIdMappings((Map<String, String>)setMapping, "");
        this.version1MappingsDao.saveOptionidMappings((Map<String, Map<String, String>>)optionsMapping);
    };

    public TextSetSettingsConverter(TextSetUpdater textSetUpdater, DatabaseSettingsManager databaseSettingsManager, SpaceSettings spaceSettings, Version1MappingsDao version1MappingsDao, SetEntityAccessor setEntityAccessor) {
        this.textSetUpdater = textSetUpdater;
        this.spaceSettings = spaceSettings;
        this.createGlobalSettingsSupplier = () -> databaseSettingsManager.getDbSettings().getDropdownOptionsMap();
        this.version1MappingsDao = version1MappingsDao;
        this.setEntityAccessor = setEntityAccessor;
    }

    Supplier<Map<String, String>> createSpaceSettingsSupplier(String spaceKey) {
        return () -> this.spaceSettings.loadOptions(spaceKey);
    }

    Consumer<List<DropdownSet<TextOption>>> spaceSetSaver(String spaceKey) {
        return dropdownSetList -> {
            for (DropdownSet dropdownSet : dropdownSetList) {
                this.setEntityAccessor.saveTextSetUnTransactional(dropdownSet, spaceKey);
            }
        };
    }

    BiConsumer<Map<String, String>, Map<String, Map<String, String>>> spaceMappingSaver(String spaceKey) {
        return (setMapping, optionsMapping) -> {
            this.version1MappingsDao.saveSetIdMappings((Map<String, String>)setMapping, spaceKey);
            this.version1MappingsDao.saveOptionidMappings((Map<String, Map<String, String>>)optionsMapping);
        };
    }

    private Map<String, String> getSingleOptionsMapping(DropdownSet<TextOption> dropdownSet) {
        HashMap<String, String> singleOptionsMapping = new HashMap<String, String>();
        ArrayList<TextOption> optionsList = dropdownSet.getOptionsList();
        for (TextOption textOption : optionsList) {
            singleOptionsMapping.put(textOption.getName().trim(), textOption.getId().trim());
        }
        return singleOptionsMapping;
    }
}

