/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.macros.DropdownState;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class EdmMacroUtils {
    private static final String CSS_CLASS = "css-style-class";

    public static boolean getBoolean(Map<String, String> parameters, String parameter, boolean defaultValue) {
        if (parameters.get(parameter) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(parameters.get(parameter));
    }

    public static boolean isLockedAndReferenced(Map<String, String> parameters, ConversionContext conversionContext) {
        boolean referenceLocked = EdmMacroUtils.getBoolean(parameters, "locked-in-page-property-report", false);
        boolean referenced = EdmMacroUtils.checkIfReferenced(conversionContext);
        return referenceLocked && referenced;
    }

    public static String getCssStyle(Map<String, String> parameters, String defaultCssClass) {
        String customCssClass = parameters.get(CSS_CLASS);
        if (customCssClass == null || StringUtils.isEmpty((String)customCssClass)) {
            return defaultCssClass;
        }
        return customCssClass;
    }

    public static DropdownState getDropdownState(DropdownSet<TextOption> chosenTextOptionSet, String currentOptionValue) {
        if (chosenTextOptionSet == null) {
            if (currentOptionValue != null) {
                return DropdownState.SET_NOT_FOUND_VALUE_WAS;
            }
            return DropdownState.SET_NOT_FOUND;
        }
        return DropdownState.OK;
    }

    private static boolean checkIfReferenced(ConversionContext conversionContext) {
        try {
            if (conversionContext.getPageContext().getEntity() instanceof Page) {
                Page pageWhereMacroIsFrom = (Page)conversionContext.getPageContext().getEntity();
                PageContext originalContext = conversionContext.getPageContext().getOriginalContext();
                Page pageWhereMacroIsRendered = (Page)originalContext.getEntity();
                return pageWhereMacroIsFrom.getId() != pageWhereMacroIsRendered.getId();
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed during reference check");
        }
    }
}

