/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.macros;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.google.gson.Gson;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.PermissionValidator;
import eps.focuspro.configui.OptionCalculator;
import eps.focuspro.configui.PermittedGroupsCollector;
import eps.focuspro.configui.helper.ImagePlaceholderHelper;
import eps.focuspro.dropdown.dtos.DropdownDto;
import eps.focuspro.dropdown.dtos.DropdownDtoCreator;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.macros.DropdownState;
import eps.focuspro.macros.EdmMacroUtils;
import eps.focuspro.macros.MacroRunner;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class DropdownMenuPredefined
implements Macro,
EditorImagePlaceholder {
    public static final String MACRO_NAME = "easy-dropdown-menu-predefined";
    private static final String FALLBACK_TEXT_SET_ID = "";
    private static final String MULTISELECT = "multi-dropdown";
    private static final String INCLUDE_BLANK = "include-blank";
    private static final String SILENT_PAGE_UPDATE = "silent-update";
    private static final int SIDE_SPACES = 10;
    private static final int MIN_WIDTH_SINGLE = 46;
    private static final int MIN_WIDTH_MULTI = 90;
    private static final int ADDITIONAL_WIDTH_OPTION = 16;
    private static final int ADDITIONAL_WIDTH_END_MULTI = 32;
    private static final int ADDITIONAL_WIDTH_ARROW_END_SINGLE = 41;
    private final DropdownDtoCreator dropdownDtoCreator;
    private final OptionCalculator optionCalculator;
    private final PermittedGroupsCollector permittedGroupsCollector;
    private final PermissionValidator permissionValidator;
    private final SetEntityAccessor setEntityAccessor;
    private final EdmSettingsManager edmSettingsManager;
    private final MacroRunner macroRunner;

    public DropdownMenuPredefined(DropdownDtoCreator dropdownDtoCreator, OptionCalculator optionCalculator, PermittedGroupsCollector permittedGroupsCollector, PermissionValidator permissionValidator, SetEntityAccessor setEntityAccessor, EdmSettingsManager edmSettingsManager, MacroRunner macroRunner) {
        this.dropdownDtoCreator = dropdownDtoCreator;
        this.optionCalculator = optionCalculator;
        this.permittedGroupsCollector = permittedGroupsCollector;
        this.permissionValidator = permissionValidator;
        this.setEntityAccessor = setEntityAccessor;
        this.edmSettingsManager = edmSettingsManager;
        this.macroRunner = macroRunner;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) {
        return this.macroRunner.execute(() -> {
            Object dropdownClass;
            DropdownDto dropdownDto = this.dropdownDtoCreator.create(parameters, conversionContext, true);
            EdmGlobalSettings databaseSettings = this.edmSettingsManager.getGlobalSettings();
            long pageId = dropdownDto.getPageId();
            String dropdownSetId = parameters.get("set-id") == null ? FALLBACK_TEXT_SET_ID : (String)parameters.get("set-id");
            String currentOptionValue = (String)parameters.get("current-option-value");
            String optionIds = (String)parameters.get("option-id");
            ArrayList<String> optionIdList = optionIds == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(optionIds.split("\\s*,\\s*")));
            boolean isIncludeBlank = parameters.get(INCLUDE_BLANK) == null || ((String)parameters.get(INCLUDE_BLANK)).equals("true");
            boolean isMultiSelect = Boolean.parseBoolean((String)parameters.get(MULTISELECT));
            boolean isSilentUpdate = Boolean.parseBoolean((String)parameters.get(SILENT_PAGE_UPDATE));
            DropdownSet<TextOption> chosenTextOptionSet = this.getChosenTextOptions(dropdownSetId, isIncludeBlank, isMultiSelect);
            DropdownState dropdownState = EdmMacroUtils.getDropdownState(chosenTextOptionSet, currentOptionValue);
            if (!dropdownState.equals((Object)DropdownState.OK)) {
                return DropdownState.getMessage(dropdownState, currentOptionValue);
            }
            List<TextOption> options = this.optionCalculator.getTextOptions(chosenTextOptionSet, optionIdList);
            List<String> combinedPermittedGroups = this.permittedGroupsCollector.collect(dropdownDto.getParameters(), dropdownDto.getSpaceKey(), databaseSettings);
            boolean hasPermissionToChangeValues = this.permissionValidator.hasUserPermission(combinedPermittedGroups, pageId, databaseSettings, AuthenticatedUserThreadLocal.get());
            String defaultPredefinedCss = databaseSettings.getDefaultPredefinedCssClass();
            String style = EdmMacroUtils.getCssStyle(parameters, defaultPredefinedCss);
            Object object = dropdownClass = isMultiSelect ? "edm-dropdown-menu-multiple" : "edm-dropdown-menu";
            if (!hasPermissionToChangeValues) {
                dropdownClass = (String)dropdownClass + " edm-edit-disabled";
            }
            if (EdmMacroUtils.isLockedAndReferenced(parameters, conversionContext)) {
                dropdownClass = (String)dropdownClass + " edm-referenced-dropdown";
            }
            if (EdmMacroUtils.getBoolean(parameters, "locked-in-page-property-report", false)) {
                dropdownClass = (String)dropdownClass + " edm-lockedInPagePropertyReport-dropdown";
            }
            if (!dropdownDto.isExport()) {
                return VelocityUtils.getRenderedTemplate((String)"velocity/dropdown-menu.vm", this.getVelocityMap(chosenTextOptionSet.getOptionsList(), options, isMultiSelect, dropdownDto.getMacroId(), pageId, isIncludeBlank, style, (String)dropdownClass, isSilentUpdate));
            }
            if (!isMultiSelect) {
                return this.getSingleOptionNameString(options);
            }
            return this.getMultipleOptionNamesString(options, false);
        });
    }

    private DropdownSet<TextOption> getChosenTextOptions(String dropdownSetId, boolean isIncludeBlank, boolean isMultiSelect) {
        DropdownSet<TextOption> chosenTextOptionSet = this.setEntityAccessor.getTextSet(dropdownSetId);
        if (chosenTextOptionSet != null && isIncludeBlank && !isMultiSelect) {
            TextOption blank = new TextOption(" ", FALLBACK_TEXT_SET_ID);
            chosenTextOptionSet.getOptionsList().add(0, blank);
        }
        return chosenTextOptionSet;
    }

    private String getSingleOptionNameString(List<TextOption> options) {
        return options.isEmpty() ? FALLBACK_TEXT_SET_ID : options.get(0).getName();
    }

    private String getMultipleOptionNamesString(List<TextOption> options, boolean forImagePlaceholder) {
        StringJoiner sj = forImagePlaceholder ? new StringJoiner("///") : new StringJoiner(", ");
        for (TextOption option : options) {
            sj.add(option.getName());
        }
        return sj.toString();
    }

    private Map<String, Object> getVelocityMap(List<TextOption> chosenTextOptionsSet, List<TextOption> chosenOptions, boolean isMulti, String macroId, long pageId, boolean isIncludeBlank, String style, String dropdownClass, boolean isSilentUpdate) {
        HashMap<String, Object> velocityMap = new HashMap<String, Object>();
        velocityMap.put("optionsSetList", new Gson().toJson(chosenTextOptionsSet));
        velocityMap.put("chosenOptions", new Gson().toJson(chosenOptions));
        velocityMap.put("isMulti", isMulti);
        velocityMap.put("macroId", macroId);
        velocityMap.put("pageId", pageId);
        velocityMap.put("isIncludeBlank", isIncludeBlank);
        velocityMap.put("style", style);
        velocityMap.put("dropdownClass", dropdownClass);
        velocityMap.put("isSilentUpdate", isSilentUpdate);
        return velocityMap;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> parameters, ConversionContext conversionContext) {
        String url;
        int imageWidth;
        String dropdownSetId = parameters.get("set-id") == null ? FALLBACK_TEXT_SET_ID : parameters.get("set-id");
        String optionIds = parameters.get("option-id");
        ArrayList<String> optionIdList = optionIds == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(optionIds.split("\\s*,\\s*")));
        String currentOptionValue = parameters.get("current-option-value");
        boolean isIncludeBlank = parameters.get(INCLUDE_BLANK) == null || parameters.get(INCLUDE_BLANK).equals("true");
        boolean isMultiSelect = Boolean.parseBoolean(parameters.get(MULTISELECT));
        DropdownSet<TextOption> chosenTextOptionSet = this.getChosenTextOptions(dropdownSetId, isIncludeBlank, isMultiSelect);
        DropdownState dropdownState = EdmMacroUtils.getDropdownState(chosenTextOptionSet, currentOptionValue);
        BufferedImage image = new BufferedImage(1, 1, 1);
        if (!dropdownState.equals((Object)DropdownState.OK)) {
            String textToDisplay = DropdownState.getMessage(dropdownState, currentOptionValue);
            int textPixelWidth = image.createGraphics().getFontMetrics().stringWidth(textToDisplay);
            imageWidth = textPixelWidth + 20;
            url = ImagePlaceholderHelper.createUrlSingleMultiPlaceholder(textToDisplay, imageWidth, true, false);
        } else {
            List<TextOption> options = this.optionCalculator.getTextOptions(chosenTextOptionSet, optionIdList);
            String textToDisplay = this.getTextToDisplay(options, isMultiSelect);
            int textPixelWidth = image.createGraphics().getFontMetrics().stringWidth(textToDisplay);
            imageWidth = this.getImageWidth(textPixelWidth, options.size(), isMultiSelect);
            url = ImagePlaceholderHelper.createUrlSingleMultiPlaceholder(textToDisplay, imageWidth, false, isMultiSelect);
        }
        return new DefaultImagePlaceholder(url, false, new ImageDimensions(imageWidth, 31));
    }

    private String getTextToDisplay(List<TextOption> options, boolean isMultiSelect) {
        return isMultiSelect ? this.getMultipleOptionNamesString(options, true) : this.getSingleOptionNameString(options);
    }

    private int getImageWidth(int textPixelWidth, int numberOfOptions, boolean isMultiSelect) {
        if (isMultiSelect) {
            int multiImageWidth = textPixelWidth + numberOfOptions * 16 + 32;
            return Math.max(multiImageWidth, 90);
        }
        return Math.max(textPixelWidth + 41, 46);
    }
}

