/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.fix.onpage;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import eps.focuspro.fix.helper.CeoConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUpdater {
    private final XhtmlContent xhtmlContent;
    private final PageManager pageManager;
    private final CeoConverter ceoConverter;
    private static final Logger log = LoggerFactory.getLogger(PageUpdater.class);

    public PageUpdater(XhtmlContent xhtmlContent, PageManager pageManager, CeoConverter ceoConverter) {
        this.xhtmlContent = xhtmlContent;
        this.pageManager = pageManager;
        this.ceoConverter = ceoConverter;
    }

    public long updateTextMacrosOnPage(Page page, Map<String, String> setMapping, Map<String, String> optionsMapping) {
        AtomicBoolean isUpdated = new AtomicBoolean(false);
        MacroDefinitionUpdater textMacroUpdater = this.getTextMacroUpdater(setMapping, optionsMapping, isUpdated);
        return this.update(page, textMacroUpdater, isUpdated);
    }

    public long updateStatusMacrosOnPage(Page page, Map<String, String> setMapping, Map<String, String> optionsMapping) {
        AtomicBoolean isUpdated = new AtomicBoolean(false);
        MacroDefinitionUpdater statusMacroUpdater = this.getStatusMacroUpdater(setMapping, optionsMapping, isUpdated);
        return this.update(page, statusMacroUpdater, isUpdated);
    }

    private long update(Page page, MacroDefinitionUpdater macroDefinitionUpdater, AtomicBoolean isUpdated) {
        if (!this.ceoConverter.isUpdatetable((ContentEntityObject)page)) {
            return 0L;
        }
        try {
            String oldBody = page.getBodyAsString();
            String updatedBody = this.updatePageBody(page, macroDefinitionUpdater);
            if (!oldBody.equals(updatedBody) && isUpdated.get()) {
                this.pageManager.saveNewVersion((ContentEntityObject)page, newPage -> newPage.setBodyAsString(updatedBody), DefaultSaveContext.MINOR_EDIT);
                return page.getId();
            }
        }
        catch (Exception e) {
            log.error("There was an error when trying to update macros on the page", (Throwable)e);
        }
        return 0L;
    }

    private String updatePageBody(Page page, MacroDefinitionUpdater macroDefinitionUpdater) throws XhtmlException {
        ConversionContext conversionContext = this.ceoConverter.getConversionContext((ContentEntityObject)page);
        String oldBody = page.getBodyAsString();
        return this.xhtmlContent.updateMacroDefinitions(oldBody, conversionContext, macroDefinitionUpdater);
    }

    private MacroDefinitionUpdater getTextMacroUpdater(Map<String, String> textSetMapping, Map<String, String> optionsMapping, AtomicBoolean isUpdated) {
        return macroDefinition -> {
            if (this.isTextMacro(macroDefinition) && this.doesMacroNeedUpdate(macroDefinition, textSetMapping)) {
                log.info("Text Set needs to be updated");
                isUpdated.getAndSet(true);
                MacroId macroId = (MacroId)macroDefinition.getMacroId().getOrNull();
                if (macroId != null) {
                    this.updateTextParameters(macroDefinition, textSetMapping, optionsMapping);
                }
            }
            return macroDefinition;
        };
    }

    private MacroDefinitionUpdater getStatusMacroUpdater(Map<String, String> statusSetMapping, Map<String, String> optionsMapping, AtomicBoolean isUpdated) {
        return macroDefinition -> {
            if (this.isStatusMacro(macroDefinition) && this.doesMacroNeedUpdate(macroDefinition, statusSetMapping)) {
                isUpdated.getAndSet(true);
                MacroId macroId = (MacroId)macroDefinition.getMacroId().getOrNull();
                if (macroId != null) {
                    this.updateStatusParameters(macroDefinition, statusSetMapping, optionsMapping);
                }
            }
            return macroDefinition;
        };
    }

    private void updateStatusParameters(MacroDefinition macroDefinition, Map<String, String> statusSetMapping, Map<String, String> optionsMapping) {
        String updatedId;
        this.updateSetId(macroDefinition, statusSetMapping);
        String optionId = macroDefinition.getParameter("option-id");
        if (StringUtils.isNotBlank((String)optionId) && StringUtils.isNotBlank((String)(updatedId = optionsMapping.get(optionId)))) {
            macroDefinition.setTypedParameter("option-id", (Object)updatedId);
        }
    }

    private void updateTextParameters(MacroDefinition macroDefinition, Map<String, String> textSetMapping, Map<String, String> optionsMapping) {
        this.updateSetId(macroDefinition, textSetMapping);
        String optionId = macroDefinition.getParameter("option-id");
        if (StringUtils.isNotBlank((String)optionId)) {
            this.updateOptionsIds(optionId, optionsMapping, macroDefinition);
        }
    }

    private void updateSetId(MacroDefinition macroDefinition, Map<String, String> setMapping) {
        String setId = this.getSetId(macroDefinition);
        String newSetId = setMapping.get(setId);
        macroDefinition.setTypedParameter("set-id", (Object)newSetId);
    }

    private boolean isStatusMacro(MacroDefinition macroDefinition) {
        return "easy-dropdown-menu-status".equals(macroDefinition.getName());
    }

    private boolean isTextMacro(MacroDefinition macroDefinition) {
        String macroName = macroDefinition.getName();
        return "easy-dropdown-menu-predefined".equals(macroName) || "easy-dropdown-menu-edit-mode".equals(macroName);
    }

    private boolean doesMacroNeedUpdate(MacroDefinition macroDefinition, Map<String, String> textSetMapping) {
        String setId = this.getSetId(macroDefinition);
        if (StringUtils.isNotBlank((String)setId)) {
            return StringUtils.isNotBlank((String)textSetMapping.get(setId));
        }
        return false;
    }

    private String getSetId(MacroDefinition macroDefinition) {
        return macroDefinition.getParameter("set-id");
    }

    private void updateOptionsIds(String oldOptionIds, Map<String, String> optionsMapping, MacroDefinition macroDefinition) {
        List<String> optionIdList = this.getOptionIdList(oldOptionIds);
        ArrayList<String> updatedList = new ArrayList<String>();
        for (String id : optionIdList) {
            String newId = optionsMapping.get(id);
            if (!StringUtils.isNotBlank((String)newId)) continue;
            updatedList.add(newId);
        }
        String updatedIdString = String.join((CharSequence)",", updatedList);
        if (!StringUtils.isBlank((String)updatedIdString)) {
            macroDefinition.setTypedParameter("option-id", (Object)updatedIdString);
        }
    }

    private List<String> getOptionIdList(String optionIds) {
        return new ArrayList<String>(Arrays.asList(optionIds.split("\\s*,\\s*")));
    }
}

