/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.config.migration;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLevelService {
    private static final Logger log4j = Logger.getLogger((String)"eps.focuspro");
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(LogLevelService.class);
    private Level level;

    public void setInfoLevel() {
        this.runSave(() -> {
            this.level = log4j.getLevel();
            log.info("Setting the log level from {} to INFO", (Object)this.level);
            log4j.setLevel(Level.INFO);
        });
        if (!log.isInfoEnabled()) {
            log.warn("Log Level is not INFO - You might miss some infos about the migration");
        }
    }

    public void resetLogLevel() {
        this.runSave(() -> {
            if (this.level != null) {
                log.info("Resetting log level to {}", (Object)this.level);
                log4j.setLevel(this.level);
            }
        });
    }

    private void runSave(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.warn("Could not change log level", (Throwable)e);
        }
    }
}

