/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.edm.persistence.entities.LozengeOptionEntity;
import eps.focuspro.edm.persistence.entities.LozengeSetEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;

public class LozengeEntityConverter {
    public DropdownSet<LozengeOption> convertFromEntity(LozengeSetEntity entity) {
        if (entity == null) {
            return null;
        }
        return this.createDropdownSet(entity);
    }

    public LozengeOptionEntity[] convertToEntity(List<LozengeOption> optionList, LozengeSetEntity lozengeSetEntity, ActiveObjects ao) {
        return (LozengeOptionEntity[])optionList.stream().map(option -> this.setUpOptionEntityFrom((LozengeOption)option, lozengeSetEntity, ao)).toArray(LozengeOptionEntity[]::new);
    }

    private DropdownSet<LozengeOption> createDropdownSet(LozengeSetEntity entity) {
        return new DropdownSet<LozengeOption>(entity.getSetId(), entity.getSetName(), this.convertFromEntity(entity.getOptionsArray()));
    }

    private ArrayList<LozengeOption> convertFromEntity(LozengeOptionEntity[] entityList) {
        if (entityList == null) {
            return new ArrayList<LozengeOption>();
        }
        return Arrays.stream(entityList).map(entity -> new LozengeOption(entity.getOptionId(), entity.getOptionName(), entity.getColor(), entity.getSubtle())).collect(Collectors.toCollection(ArrayList::new));
    }

    private LozengeOptionEntity setUpOptionEntityFrom(LozengeOption option, LozengeSetEntity lozengeSetEntity, ActiveObjects ao) {
        LozengeOptionEntity lozengeOptionEntity = (LozengeOptionEntity)ao.create(LozengeOptionEntity.class, new DBParam[0]);
        lozengeOptionEntity.setOptionId(option.getId());
        lozengeOptionEntity.setOptionName(option.getName());
        lozengeOptionEntity.setColor(option.getColor());
        lozengeOptionEntity.setSubtle(option.getSubtle());
        lozengeOptionEntity.setLozengeSetEntity(lozengeSetEntity);
        return lozengeOptionEntity;
    }
}

