/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.edm.persistence.entities.SetHistoryEntity;
import eps.focuspro.history.historyObjects.OptionHistoryChange;
import eps.focuspro.history.historyObjects.SetHistory;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;

public class HistoryLozengeEntityConverter {
    public SetHistory<LozengeOption> convertFromEntity(List<SetHistoryEntity> setHistoryEntityList, String setId) {
        return new SetHistory<LozengeOption>(setId, this.convertOptionHistoryChanges(setHistoryEntityList));
    }

    public void convertToEntity(SetHistory<LozengeOption> setHistory, ActiveObjects ao) {
        for (OptionHistoryChange<LozengeOption> change : setHistory.getHistoryList()) {
            LozengeOption oldOption = change.getOldOption();
            LozengeOption newOption = change.getNewOption();
            SetHistoryEntity entity = (SetHistoryEntity)ao.create(SetHistoryEntity.class, new DBParam[0]);
            entity.setSetId(setHistory.getSetId());
            entity.setOptionId(oldOption.getId());
            entity.setOldOptionName(oldOption.getName());
            entity.setOldColor(oldOption.getColor());
            entity.setOldSubtle(oldOption.getSubtle());
            entity.setNewOptionName(newOption.getName());
            entity.setNewColor(newOption.getColor());
            entity.setNewSubtle(newOption.getSubtle());
            entity.setDateTime(change.getDateTime());
            entity.setUsername(change.getUserName());
            entity.setHistoryEvent(change.getEvent());
            entity.save();
        }
    }

    private List<OptionHistoryChange<LozengeOption>> convertOptionHistoryChanges(List<SetHistoryEntity> setHistoryEntityList) {
        return setHistoryEntityList.stream().map(entity -> new OptionHistoryChange<LozengeOption>(this.getOldOption((SetHistoryEntity)entity), this.getNewOption((SetHistoryEntity)entity), entity.getDateTime(), entity.getUsername(), entity.getHistoryEvent())).collect(Collectors.toList());
    }

    private LozengeOption getOldOption(SetHistoryEntity entity) {
        return new LozengeOption(entity.getOptionId(), entity.getOldOptionName(), entity.getOldColor(), entity.getOldSubtle());
    }

    private LozengeOption getNewOption(SetHistoryEntity entity) {
        return new LozengeOption(entity.getOptionId(), entity.getNewOptionName(), entity.getNewColor(), entity.getNewSubtle());
    }
}

