/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import java.util.Base64;

public class FormatUtils {
    public static String getColonSeparatedValue(String s1, String s2) {
        if (s1 == null || s2 == null) {
            throw new RuntimeException(String.format("The first string: %s or the second string: %s  was null", s1, s2));
        }
        return String.format("%s:%s", s1, s2);
    }

    public static String createEncodedQuery(String value) {
        value = FormatUtils.removeNoIgnore(value);
        return "\"" + FormatUtils.encodeToBase64(value) + "\"";
    }

    public static String encodeToBase64(String value) {
        if (value == null) {
            throw new RuntimeException("Can't convert null to base64");
        }
        return Base64.getEncoder().encodeToString(value.getBytes());
    }

    private static String removeNoIgnore(String searchTerm) {
        String[] split = searchTerm.split(":");
        if (split.length > 1 && FormatUtils.containsNoIgnore(searchTerm)) {
            searchTerm = searchTerm.replaceAll("noIgnore ", " ").replaceAll(":(\\s*)", ":");
        }
        return searchTerm;
    }

    private static boolean containsNoIgnore(String searchTerm) {
        return searchTerm.contains("noIgnore ");
    }
}

