/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import eps.focuspro.cql.FieldCreator;
import eps.focuspro.cql.MacroValuesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldDescriptorService {
    private final MacroValuesProvider macroValuesProvider;
    private final FieldCreator fieldCreator;
    private static final Logger log = LoggerFactory.getLogger(FieldDescriptorService.class);

    public FieldDescriptorService(MacroValuesProvider macroValuesProvider, FieldCreator fieldCreator) {
        this.macroValuesProvider = macroValuesProvider;
        this.fieldCreator = fieldCreator;
    }

    public List<FieldDescriptor> computeEDMFieldDescriptors(XhtmlContent xhtmlContent, ConversionContext conversionContext, MacroDefinition macro) {
        List<FieldDescriptor> fieldDescriptorList = new ArrayList<FieldDescriptor>();
        Map parameters = macro.getParameters();
        String macroName = macro.getName();
        if (StringUtils.isNotBlank((String)macroName)) {
            switch (macroName) {
                case "easy-dropdown-menu": {
                    log.debug("Extracting non predefined field");
                    fieldDescriptorList = this.createNonPredefinedFields(parameters);
                    break;
                }
                case "easy-dropdown-menu-predefined": 
                case "easy-dropdown-menu-edit-mode": {
                    log.debug("Extracting text macro field");
                    fieldDescriptorList = this.createTextFields(parameters);
                    break;
                }
                case "easy-dropdown-menu-status": {
                    log.debug("Extracting status macro field");
                    fieldDescriptorList = this.createStatusFields(parameters);
                    break;
                }
                case "details": {
                    log.debug("extracting pageProperty Report macro");
                    fieldDescriptorList = this.extractFieldDescriptorFromTable(xhtmlContent, conversionContext, macro);
                    break;
                }
            }
        }
        return fieldDescriptorList;
    }

    private List<FieldDescriptor> createNonPredefinedFields(Map<String, String> parameters) {
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        List<String> currentOptionIdsFromText = this.macroValuesProvider.getCurrentOptionIdsFromText(parameters);
        List<String> currentOptionList = this.macroValuesProvider.getCurrentOptionListFromNonPredefinedMacro(parameters);
        List<FieldDescriptor> fieldDescriptors = this.fieldCreator.createFullOptionDescriptors(currentOptionList, "EdmOption", "");
        fieldDescriptors.addAll(this.fieldCreator.createSetAndOptionIdDescriptors(setId, currentOptionIdsFromText));
        return fieldDescriptors;
    }

    private List<FieldDescriptor> createTextFields(Map<String, String> parameters) {
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        List<String> currentOptionIdsFromText = this.macroValuesProvider.getCurrentOptionIdsFromText(parameters);
        List<String> currentOptionsList = this.macroValuesProvider.getCurrentOptionListFromTextMacro(setId, currentOptionIdsFromText);
        List<FieldDescriptor> fieldDescriptors = this.fieldCreator.createFullOptionDescriptors(currentOptionsList, "EdmOption", "");
        fieldDescriptors.addAll(this.fieldCreator.createSetAndOptionIdDescriptors(setId, currentOptionIdsFromText));
        return fieldDescriptors;
    }

    private List<FieldDescriptor> createStatusFields(Map<String, String> parameters) {
        String optionId;
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        String currentOptionValue = this.macroValuesProvider.getCurrentOptionFromStatusMacro(setId, optionId = this.macroValuesProvider.getCurrentOptionIdFromStatus(parameters));
        if (currentOptionValue != null) {
            fields.addAll(this.fieldCreator.createFullOptionDescriptors(Collections.singletonList(currentOptionValue), "EdmStatusOption", ""));
        }
        ArrayList<String> optionIdList = new ArrayList<String>();
        optionIdList.add(optionId);
        fields.addAll(this.fieldCreator.createSetAndOptionIdDescriptors(setId, optionIdList));
        return fields;
    }

    private List<FieldDescriptor> createNonPredefinedFieldsLinkedToTitle(Map<String, String> parameters, String pageProperty) {
        List<String> currentOptionValueList = this.macroValuesProvider.getCurrentOptionListFromNonPredefinedMacro(parameters);
        List<FieldDescriptor> fieldDescriptors = this.fieldCreator.createFullOptionDescriptors(currentOptionValueList, "EdmOption", pageProperty);
        return fieldDescriptors;
    }

    private List<FieldDescriptor> createPredefinedFieldsLinkedToTitle(Map<String, String> parameters, String pageProperty) {
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        List<String> currentOptionIdsFromText = this.macroValuesProvider.getCurrentOptionIdsFromText(parameters);
        List<String> currentOptionsList = this.macroValuesProvider.getCurrentOptionListFromTextMacro(setId, currentOptionIdsFromText);
        return this.fieldCreator.createFullOptionDescriptors(currentOptionsList, "EdmOption", pageProperty);
    }

    private List<FieldDescriptor> createStatusFieldsLinkedToTitle(Map<String, String> parameters, String pageProperty) {
        String currentOptionId;
        String setId = this.macroValuesProvider.getUniversalSetId(parameters);
        String currentOptionValue = this.macroValuesProvider.getCurrentOptionFromStatusMacro(setId, currentOptionId = this.macroValuesProvider.getCurrentOptionIdFromStatus(parameters));
        if (StringUtils.isNotBlank((String)currentOptionValue)) {
            return this.fieldCreator.createFullOptionDescriptors(Collections.singletonList(currentOptionValue), "EdmStatusOption", pageProperty);
        }
        return new ArrayList<FieldDescriptor>();
    }

    private List<FieldDescriptor> extractFieldDescriptorFromTable(XhtmlContent xhtmlContent, ConversionContext conversionContext, MacroDefinition macro) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        Element table = this.getTableElementInsidePageProperties(macro);
        if (table != null && StringUtils.isNotBlank((String)table.toString())) {
            for (Element row : table.select("tr")) {
                fieldDescriptors.addAll(this.extractFieldDescriptorFromRow(row, xhtmlContent, conversionContext));
            }
        }
        return fieldDescriptors;
    }

    private Element getTableElementInsidePageProperties(MacroDefinition macro) {
        String macroBodyString = macro.getStorageBodyStream().toString();
        Document macroBodyDocument = Jsoup.parse((String)macroBodyString, (String)"", (Parser)Parser.xmlParser());
        macroBodyDocument.outputSettings().prettyPrint(false);
        return macroBodyDocument.select("table").first();
    }

    private List<FieldDescriptor> extractFieldDescriptorFromRow(Element row, XhtmlContent xhtmlContent, ConversionContext conversionContext) {
        Element cell;
        String pageProperty = row.select("th").text();
        if (StringUtils.isNotBlank((String)pageProperty) && (cell = row.select("td").first()) != null && StringUtils.isNotBlank((String)cell.toString())) {
            return this.extractMacroValuesFromCell(xhtmlContent, cell.toString(), conversionContext, pageProperty);
        }
        return new ArrayList<FieldDescriptor>();
    }

    private List<FieldDescriptor> extractMacroValuesFromCell(XhtmlContent xhtmlContent, String cellContent, ConversionContext conversionContext, String pageProperty) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        try {
            xhtmlContent.handleMacroDefinitions(cellContent, conversionContext, macroDefinition -> {
                List<FieldDescriptor> extractedFields = this.extractFieldDescriptorFromMacroInCell(macroDefinition, pageProperty);
                fields.addAll(extractedFields);
            });
        }
        catch (XhtmlException e) {
            log.warn("An Error occurred Filtering out Macros of Td Element in PageProperties", (Throwable)e);
            log.debug("The cellContent was: {}", (Object)cellContent);
        }
        return fields;
    }

    private List<FieldDescriptor> extractFieldDescriptorFromMacroInCell(MacroDefinition macro, String pageProperty) {
        Map parameters = macro.getParameters();
        String macroName = macro.getName();
        if (StringUtils.isNotBlank((String)macroName)) {
            switch (macroName) {
                case "easy-dropdown-menu": {
                    return this.createNonPredefinedFieldsLinkedToTitle(parameters, pageProperty);
                }
                case "easy-dropdown-menu-predefined": 
                case "easy-dropdown-menu-edit-mode": {
                    return this.createPredefinedFieldsLinkedToTitle(parameters, pageProperty);
                }
                case "easy-dropdown-menu-status": {
                    return this.createStatusFieldsLinkedToTitle(parameters, pageProperty);
                }
            }
        }
        return new ArrayList<FieldDescriptor>();
    }
}

