/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import eps.focuspro.cql.FormatUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FieldCreator {
    public List<FieldDescriptor> createFullOptionDescriptors(List<String> options, String indexableProperty, String pageProperty) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        options.forEach(option -> {
            if (!StringUtils.isBlank((String)option)) {
                if (!StringUtils.isBlank((String)pageProperty)) {
                    option = FormatUtils.getColonSeparatedValue(pageProperty, option);
                }
                String id = FormatUtils.encodeToBase64(option);
                String fieldDescriptorValue = FormatUtils.getColonSeparatedValue(id + " ", option);
                fieldDescriptors.add(new FieldDescriptor(indexableProperty, fieldDescriptorValue, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED));
            }
        });
        return fieldDescriptors;
    }

    public List<FieldDescriptor> createSetAndOptionIdDescriptors(String setId, List<String> optionIds) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        if (!setId.equals("")) {
            fieldDescriptors.add(this.createSetIdFieldDescriptor(setId));
        }
        for (String optionId : optionIds) {
            if (optionId == null || optionId.equals("")) continue;
            fieldDescriptors.add(this.createOptionIdFieldDescriptor(optionId));
        }
        return fieldDescriptors;
    }

    private FieldDescriptor createSetIdFieldDescriptor(String setId) {
        return new FieldDescriptor("EdmSetId", setId, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
    }

    private FieldDescriptor createOptionIdFieldDescriptor(String optionId) {
        return new FieldDescriptor("EdmOptionId", optionId, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
    }
}

