/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui;

import eps.focuspro.configui.LozengeType;
import eps.focuspro.configui.helper.ImagePlaceholderHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePlaceholderStatusGenerator
extends HttpServlet {
    private static final int imageHeight = 24;
    private static final Color REQUEST_GREY = new Color(204, 204, 204);
    private static final Color REQUEST_GREEN = new Color(20, 137, 44);
    private static final Color REQUEST_RED = new Color(208, 68, 55);
    private static final Color REQUEST_YELLOW = new Color(246, 195, 66);
    private static final Color REQUEST_BLUE = new Color(74, 103, 133);
    private static final Color REQUEST_BROWN = new Color(129, 91, 58);
    private static final Font font = new Font("Monospaced", 1, 14);
    private static final Logger log = LoggerFactory.getLogger(ImagePlaceholderStatusGenerator.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String text = req.getParameter("text");
        String color = req.getParameter("color");
        LozengeType lozengeType = Boolean.parseBoolean(req.getParameter("subtle")) ? LozengeType.SUBTLE : LozengeType.STANDARD;
        int imageWidth = Integer.parseInt(req.getParameter("length"));
        HashMap<String, Color> colorSettings = this.getColorFromReq(color, lozengeType);
        Color backgroundColor = colorSettings.get("backgroundColor");
        Color fontColor = colorSettings.get("fontColor");
        BufferedImage image = new BufferedImage(imageWidth, 24, 1);
        Graphics2D graphics2D = image.createGraphics();
        ImagePlaceholderHelper.setBackground(imageWidth, 24, backgroundColor, image, graphics2D, lozengeType);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ImagePlaceholderHelper.drawText(graphics2D, text, font, fontColor, 15, 17);
        resp.setContentType("image/png");
        try {
            ImageIO.write((RenderedImage)image, "png", (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            log.error("Error on EditorPlaceholder", (Throwable)e);
        }
    }

    private HashMap<String, Color> getColorFromReq(String color, LozengeType lozengeType) {
        HashMap<String, Color> colorSettings = new HashMap<String, Color>();
        colorSettings.put("fontColor", Color.WHITE);
        switch (color) {
            case "grey": {
                colorSettings.put("backgroundColor", REQUEST_GREY);
                colorSettings.replace("fontColor", Color.BLACK);
                break;
            }
            case "green": {
                colorSettings.put("backgroundColor", REQUEST_GREEN);
                break;
            }
            case "red": {
                colorSettings.put("backgroundColor", REQUEST_RED);
                break;
            }
            case "yellow": {
                colorSettings.put("backgroundColor", REQUEST_YELLOW);
                colorSettings.replace("fontColor", Color.BLACK);
                break;
            }
            case "blue": {
                colorSettings.put("backgroundColor", REQUEST_BLUE);
                break;
            }
            case "brown": {
                colorSettings.put("backgroundColor", REQUEST_BROWN);
            }
        }
        if (lozengeType.equals((Object)LozengeType.SUBTLE)) {
            colorSettings.replace("fontColor", colorSettings.get("backgroundColor"));
        }
        return colorSettings;
    }
}

