/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.thoughtworks.xstream.XStream;
import eps.focuspro.configui.DatabaseSettings;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DatabaseSettingsManager {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSettingsManager.class);
    private static final String ADD_ON_KEY = "eps.easydropdownmenu-database";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final XStream xStream;

    public DatabaseSettingsManager(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.xStream = new XStream();
        this.xStream.setClassLoader(DatabaseSettingsManager.class.getClassLoader());
    }

    public DatabaseSettings getDbSettings() {
        return this.loadSettings();
    }

    public void save(DatabaseSettings dbSettings) {
        try {
            PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
            String xml = this.xStream.toXML((Object)dbSettings);
            pluginSettings.put(ADD_ON_KEY, (Object)xml);
        }
        catch (Exception e) {
            log.warn("Could not save setting in database", (Throwable)e);
        }
    }

    public DatabaseSettings getDefaultDbSettings() {
        DatabaseSettings settings = new DatabaseSettings();
        settings.setCssColorValidValue("");
        settings.setCssColorInvalidValue("");
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("Agree", "Agree,Disagree,Partly Agree");
        optionsMap.put("Letters (a,b,c)", "a,b,c");
        optionsMap.put("Numbers (1,2,3,4)", "1,2,3,4");
        HashMap<String, Map<String, String>> statusOptionMap = new HashMap<String, Map<String, String>>();
        statusOptionMap.put("Default", this.getDefaultStatusMap());
        settings.setConfigStatusOptions(statusOptionMap);
        settings.setDropdownOptionsMap(optionsMap);
        settings.setDefaultDropdownOptions("");
        settings.setCssDropdownMenu("background:#EEEEEE");
        settings.setCssDropdownMenuPredefined("");
        settings.setCssEditModeValid("");
        settings.setCssEditModeInvalid("");
        settings.setEditModeTextNoValue("");
        settings.setSuppressNotifications(true);
        settings.setAllowAnonymous(false);
        settings.setAllowWithoutEditPermissions(false);
        return settings;
    }

    private DatabaseSettings loadSettings() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get(ADD_ON_KEY);
        if (!(value instanceof String)) {
            if (value != null) {
                log.warn("Unknown format of settings {} - loading default settings", (Object)value.getClass().getName());
            } else {
                log.info("Loading initial settings");
            }
            return this.getDefaultDbSettings();
        }
        DatabaseSettings dbSettings = this.xmlToDbSettings(value.toString());
        return dbSettings != null ? dbSettings : this.getDefaultDbSettings();
    }

    private DatabaseSettings xmlToDbSettings(String xmlString) {
        try {
            Object xml = this.xStream.fromXML(xmlString);
            return (DatabaseSettings)xml;
        }
        catch (Exception e) {
            log.warn("Current Settings {}", (Object)xmlString);
            log.warn("Could not convert EDM settings from XML - loading default settings", (Throwable)e);
            return this.getDefaultDbSettings();
        }
    }

    private Map<String, String> getDefaultStatusMap() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("green", "SUCCESS");
        valueMap.put("blue", "COMPLETE");
        valueMap.put("yellow", "CURRENT");
        valueMap.put("red", "ERROR");
        valueMap.put("brown", "MOVED");
        valueMap.put("grey", "GENERIC");
        return valueMap;
    }
}

