/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.rest.helper.ResourcesRunner;
import eps.focuspro.rest.helper.exceptions.DataNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionValidator {
    private final PermissionManager permissionManager;
    private final PageManager pageManager;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final SpaceManager spaceManager;
    private static final Logger log = LoggerFactory.getLogger(ResourcesRunner.class);

    public PermissionValidator(PermissionManager permissionManager, PageManager pageManager, UserManager userManager, GroupManager groupManager, SpaceManager spaceManager) {
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.spaceManager = spaceManager;
    }

    public boolean isEditingAllowed(long pageId, EdmGlobalSettings databaseSettings) {
        return this.isNotAnonymousOrAllowed(databaseSettings.isAllowAnonymous()) && pageId > 0L && this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), databaseSettings.isAllowWithoutEditPermission() ? Permission.VIEW : Permission.EDIT, (Object)this.pageManager.getAbstractPage(pageId));
    }

    public boolean isNotAnonymousOrAllowed(boolean isAllowAnonymous) {
        return !AuthenticatedUserThreadLocal.isAnonymousUser() || isAllowAnonymous;
    }

    public boolean isCurrentUserAdmin(ConfluenceUser user) {
        return this.permissionManager.isSystemAdministrator((User)user) || this.permissionManager.isConfluenceAdministrator((User)user);
    }

    public boolean isCurrentUserSpaceAdmin(ConfluenceUser user, String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            String message = "Space could not be found";
            log.error(message);
            throw new DataNotFoundException(message);
        }
        return this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)space);
    }

    private UserKey getUserKey() {
        return this.userManager.getRemoteUserKey();
    }

    public List<Group> getAllGroups() {
        return this.groupManager.getWritableGroups();
    }

    public List<String> getGroupNamesFromGroups(List<Group> uiGroups) {
        ArrayList<String> uiGroupNames = new ArrayList<String>();
        if (uiGroups != null) {
            for (Group group : uiGroups) {
                uiGroupNames.add(group.getName());
            }
        }
        return uiGroupNames;
    }

    public boolean hasUserPermission(List<String> groupNames, long pageId, EdmGlobalSettings databaseSettings, ConfluenceUser user) {
        UserKey userKey = this.getUserKey();
        if (groupNames.isEmpty() && this.isEditingAllowed(pageId, databaseSettings)) {
            return true;
        }
        if (this.isEditingAllowed(pageId, databaseSettings)) {
            for (String group : groupNames) {
                if (!this.userManager.isUserInGroup(userKey, group)) continue;
                return true;
            }
        }
        return false;
    }
}

