export const convertToUniversalSetSelectObject = function (valueArray) {
    const groups = [];
    for (let i = 0, length = valueArray.length; i < length; i++) {
        if (typeof valueArray[i]["id"] === "string") {
            groups.push({id: valueArray[i]["id"], text: valueArray[i]["name"]});
        }
    }
    return groups;
};

const getColorList = function () {
    return (['grey', 'green', 'red', 'yellow', 'blue', 'brown'])
};

export const statusEditorColorDropdownObject = function () {
    const groups = [];
    const colorList = getColorList();
    const subtle = "aui-lozenge";
    colorList.forEach(function (color) {
        let text;
        if (typeof color === "string") {
            switch (color) {
                case "green":
                    text = "<span  class=\"" + subtle + " edm-aui-lozenge-success" + " dropdowncontainer-config-css\"></span>";
                    break;
                case "red":
                    text = "<span  class=\"" + subtle + " edm-aui-lozenge-error" + " dropdowncontainer-config-css\"></span>";
                    break;
                case "yellow":
                    text = "<span  class=\"" + subtle + " edm-aui-lozenge-current" + " dropdowncontainer-config-css\"></span>";
                    break;
                case "blue":
                    text = "<span  class=\"" + subtle + " edm-aui-lozenge-complete" + " dropdowncontainer-config-css\"></span>";
                    break;
                case "brown":
                    text = "<span  class=\"" + subtle + " edm-aui-lozenge-moved"
                        + " dropdowncontainer-config-css\"></span>";
                    break;
                default:
                    text = "<span  class=\"" + subtle
                        + " edm-aui-lozenge-generic"
                        + " dropdowncontainer-config-css\"></span>";
            }
            groups.push({id: color, text: text});
        }
    });
    return groups;
};

export const convertToStatusSelectObject = function (valueList) {
    const groups = [];
    let subtle;
    valueList.forEach(function (option) {
        let text;
        if (option.subtle) {
            subtle = "aui-lozenge aui-lozenge-subtle";
            if (typeof option.color === "string") {
                switch (option.color) {
                    case "green":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-success\""
                            + " style='background-color: #ffffff;color: #14892c;border-color: #14892c;border-width: thin;'>"
                            + option.name + "</span>";
                        break;
                    case "red":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-error\""
                            + " style='background-color: #ffffff;color: #d04437;border-color: #d04437;border-width: thin;'>"
                            + option.name + "</span>";
                        break;
                    case "yellow":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-current\""
                            + " style='background-color: #ffffff;color: #ffd351;border-color: #ffd351;border-width: thin;'>"
                            + option.name + "</span>";
                        break;
                    case "blue":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-complete\""
                            + " style='background-color: #ffffff;color: #4a6785;border-color: #4a6785;border-width: thin;'>"
                            + option.name + "</span>";
                        break;
                    case "brown":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-moved\" "
                            + "style='background-color: #ffffff;color: #815b3a;border-color: #815b3a;border-width: thin;'>"
                            + option.name + "</span>";
                        break;
                    default:
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-generic\" "
                            + " style='background-color: #ffffff;color: #dfe1e6;border-color: #dfe1e6;border-width: thin;'>"
                            + option.name + "</span>";
                }
                groups.push({id: option.id, text: text});
            }
        } else {
            subtle = "aui-lozenge";
            if (typeof option.color === "string") {
                switch (option.color) {
                    case "green":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-success\""
                            + " style='background-color: #14892c;color: #ffffff;border-color: #14892c;'>"
                            + option.name + "</span>";
                        break;
                    case "red":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-error\""
                            + " style='background-color: #d04437;color: #ffffff;border-color: #d04437;'>"
                            + option.name + "</span>";
                        break;
                    case "yellow":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-current\""
                            + " style='background-color: #ffd351;color: #253858;border-color: #ffd351;'>"
                            + option.name + "</span>";
                        break;
                    case "blue":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-complete\""
                            + " style='background-color: #4a6785;color: #ffffff;border-color: #4a6785;'>"
                            + option.name + "</span>";
                        break;
                    case "brown":
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-moved\""
                            + " style='background-color: #815b3a;color: #ffffff;border-color: #815b3a;'>"
                            + option.name + "</span>";
                        break;
                    default:
                        text = "<span  class=\"" + subtle
                            + " edm-aui-lozenge-generic\""
                            + " style='background-color: #dfe1e6;color: #42526e;border-color: #dfe1e6;'>"
                            + option.name + "</span>";
                }
                groups.push({id: option.id, text: text});
            }
        }
    });
    return groups;
};


export const convertToTextOptionSelectObject = function (valueList) {
    const groups = [];
    valueList.forEach(function (option) {
        groups.push({id: option.id, text: option.name});
    });
    return groups;
};

export const getCurrentOptionsArrayFromResp = function (input, resp) {
    const optionIds = input.val();
    input.val(null).trigger("change");
    if (optionIds) {
        return optionIds.split(",").map(optionId => resp.find(option => option.id === optionId) || {id: optionId, name: "OptionNotFound"});
    }
    return [];
};

export const templateGet = function (data) {
    return data.text;
};

export const convertToSelectObject = function (valueArray) {
    const groups = [];
    for (let i = 0, length = valueArray.length; i < length; i++) {
        if (typeof valueArray[i] === "string") {
            groups.push({id: valueArray[i], text: valueArray[i]});
        }
    }
    return groups;
};

export const changeLinkToSpan = function (entry) {
    const aElement = AJS.$("a", entry).first();
    const spanElement = document.createElement("span");
    spanElement.setAttribute("class", aElement.attr("class"));
    spanElement.setAttribute("tabindex", "-1");
    copyEventHandlers(aElement, spanElement);
    entry.replaceChild(spanElement, aElement.get(0));
};

const copyEventHandlers = function (oldElement, newElement) {
    AJS.$.each(AJS.$._data(AJS.$(oldElement).get(0), "events"), function () {
        AJS.$.each(this, function () {
            AJS.$(newElement).bind(this.type, this.handler);
        });
    });
};

export const unwrapDiv = function (entry) {
    const divElement = AJS.$("div", entry).first();
    const innerHtmlDiv = divElement.html();
    if (typeof innerHtmlDiv !== "undefined") {
        const innerHtmlNode = document.createTextNode(innerHtmlDiv);
        entry.replaceChild(innerHtmlNode, divElement.get(0));
    }
};


