/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.helper;

import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Option;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import eps.focuspro.rest.dtos.DataMigrationDto;
import eps.focuspro.rest.dtos.SpaceDto;
import eps.focuspro.rest.helper.exceptions.DataNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMigrationHandler {
    private static final String GLOBAL_CONFIG_NAME = "Global Configurations";
    private static final String GLOBAL_CONFIG_KEY = "";
    private static final Logger log = LoggerFactory.getLogger(DataMigrationHandler.class);
    private final SpaceService spaceService;
    private final SpaceManager spaceManager;
    private final SetEntityAccessor setEntityAccessor;
    private final EdmSettingsManager edmSettingsManager;

    public DataMigrationHandler(SpaceService spaceService, SpaceManager spaceManager, SetEntityAccessor setEntityAccessor, EdmSettingsManager edmSettingsManager) {
        this.spaceService = spaceService;
        this.spaceManager = spaceManager;
        this.setEntityAccessor = setEntityAccessor;
        this.edmSettingsManager = edmSettingsManager;
    }

    public DataMigrationDto getDataMigrationDto(String spaceKey) {
        if (spaceKey.isEmpty()) {
            return this.createDataMigrationDto(GLOBAL_CONFIG_NAME, GLOBAL_CONFIG_KEY, this.edmSettingsManager.getGlobalSettings().getPermittedGroups());
        }
        SpaceLocator spaceLocator = this.spaceService.getKeySpaceLocator(spaceKey);
        Space space = spaceLocator.getSpace();
        if (space != null) {
            return this.createDataMigrationDto(space.getName(), space.getKey(), this.edmSettingsManager.getSpaceSettings(spaceKey).getPermittedGroups());
        }
        String message = "Space with key: '" + spaceKey + "' not found";
        log.error(message);
        throw new DataNotFoundException(message);
    }

    public List<SpaceDto> getSpaceDtoList() {
        List spaceList = this.spaceManager.getAllSpaces();
        ArrayList<SpaceDto> spaceDtos = new ArrayList<SpaceDto>();
        spaceDtos.add(new SpaceDto(GLOBAL_CONFIG_NAME, GLOBAL_CONFIG_KEY));
        for (Space space : spaceList) {
            spaceDtos.add(new SpaceDto(space.getName(), space.getKey()));
        }
        return spaceDtos;
    }

    public <T extends Option> DropdownSet<T> mergeSets(DropdownSet<T> importedSet, DropdownSet<T> existingSet) {
        if (existingSet == null) {
            return importedSet;
        }
        ArrayList existingOptions = existingSet.getOptionsList();
        for (Option importedOption : importedSet.getOptionsList()) {
            int optionIndex = IntStream.range(0, existingOptions.size()).filter(index -> importedOption.getId().equals(((Option)existingOptions.get(index)).getId())).findFirst().orElse(-1);
            if (optionIndex != -1) {
                existingOptions.set(optionIndex, importedOption);
                continue;
            }
            existingOptions.add(importedOption);
        }
        return existingSet;
    }

    public void mergeAndSavePermittedGroups(String spaceKey, List<String> permittedGroups) {
        if (!permittedGroups.isEmpty()) {
            if (spaceKey.equals(GLOBAL_CONFIG_KEY)) {
                EdmGlobalSettings edmGlobalSettings = this.edmSettingsManager.getGlobalSettings();
                this.mergePermittedGroups(permittedGroups, edmGlobalSettings.getPermittedGroups());
                this.edmSettingsManager.saveGlobalSettings(edmGlobalSettings);
            } else {
                EdmSpaceSettings edmSpaceSettings = this.edmSettingsManager.getSpaceSettings(spaceKey);
                this.mergePermittedGroups(permittedGroups, edmSpaceSettings.getPermittedGroups());
                this.edmSettingsManager.saveSpaceSettings(edmSpaceSettings);
            }
        }
    }

    private DataMigrationDto createDataMigrationDto(String spaceName, String spaceKey, List<String> permittedGroups) {
        List<DropdownSet<TextOption>> textSets = this.setEntityAccessor.getTextSetsSpaceOrGlobal(spaceKey);
        List<DropdownSet<LozengeOption>> lozengeSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey);
        return new DataMigrationDto(spaceName, spaceKey, textSets, lozengeSets, permittedGroups);
    }

    private void mergePermittedGroups(List<String> importedGroups, List<String> permittedGroups) {
        for (String importedGroup : importedGroups) {
            if (permittedGroups.contains(importedGroup)) continue;
            permittedGroups.add(importedGroup);
        }
    }
}

