/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import eps.focuspro.PermissionValidator;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.fix.DuplicationAnalyzer;
import eps.focuspro.fix.DuplicationFinder;
import eps.focuspro.fix.onpage.PageUpdater;
import eps.focuspro.migration.macroMigration.SchemaVersion1Updater;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import eps.focuspro.search.MappingExecuter;
import eps.focuspro.search.PageSearcher;
import eps.focuspro.taskUtils.core.TaskManager;
import eps.focuspro.taskUtils.dtos.ActionResponse;
import eps.focuspro.taskUtils.helper.PageUrlMappingProvider;
import eps.focuspro.taskUtils.tasks.DuplicationResolveTask;
import eps.focuspro.taskUtils.tasks.MacroUpdateTask;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/edm-task")
@Consumes(value={"application/json"})
@Produces(value={"text/html"})
public class RestTask {
    private final PermissionValidator permissionValidator;
    private final SchemaVersion1Updater schemaVersion1Updater;
    private final TaskManager taskManager;
    private final PageSearcher pageSearcher;
    private final MappingExecuter mappingExecuter;
    private final DuplicationFinder duplicationFinder;
    private final SetEntityAccessor setEntityAccessor;
    private final PageUpdater pageUpdater;
    private final DuplicationAnalyzer duplicationAnalyzer;
    private final ActiveObjects ao;
    private final PageUrlMappingProvider pageUrlMappingProvider;
    private final TransactionTemplate transactionTemplate;
    private final ResourcesRunner resourcesRunner;

    public RestTask(PermissionValidator permissionValidator, SchemaVersion1Updater schemaVersion1Updater, TaskManager taskManager, PageSearcher pageSearcher, MappingExecuter mappingExecuter, DuplicationFinder duplicationFinder, SetEntityAccessor setEntityAccessor, PageUpdater pageUpdater, DuplicationAnalyzer duplicationAnalyzer, ActiveObjects ao, PageUrlMappingProvider pageUrlMappingProvider, TransactionTemplate transactionTemplate, ResourcesRunner resourcesRunner) {
        this.permissionValidator = permissionValidator;
        this.schemaVersion1Updater = schemaVersion1Updater;
        this.taskManager = taskManager;
        this.pageSearcher = pageSearcher;
        this.mappingExecuter = mappingExecuter;
        this.duplicationFinder = duplicationFinder;
        this.setEntityAccessor = setEntityAccessor;
        this.pageUpdater = pageUpdater;
        this.duplicationAnalyzer = duplicationAnalyzer;
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.pageUrlMappingProvider = pageUrlMappingProvider;
        this.transactionTemplate = transactionTemplate;
        this.resourcesRunner = resourcesRunner;
    }

    @AnonymousAllowed
    @GET
    @Produces(value={"application/json"})
    @Path(value="/migrateDropDowns")
    @ReadOnlyAccessBlocked
    public Response migrateAllDropdowns() {
        return this.resourcesRunner.run(() -> {
            MacroUpdateTask task = new MacroUpdateTask(this.taskManager, this.schemaVersion1Updater, this.pageSearcher, this.mappingExecuter, this.pageUrlMappingProvider);
            String longRunningTaskId = this.taskManager.start(task);
            return Response.ok((Object)new ActionResponse(longRunningTaskId, task.getResponseId())).build();
        }, new ResourceContextBuilder().withGlobalAdminRights().build());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/resolveDuplication")
    @ReadOnlyAccessBlocked
    public Response eliminateDuplicatedStuff() {
        return this.resourcesRunner.run(() -> {
            DuplicationResolveTask task = new DuplicationResolveTask(this.taskManager, this.duplicationFinder, this.mappingExecuter, this.setEntityAccessor, this.pageUpdater, this.duplicationAnalyzer, this.ao, this.pageUrlMappingProvider, this.transactionTemplate);
            String longRunningTaskId = this.taskManager.start(task);
            return Response.ok((Object)new ActionResponse(longRunningTaskId, task.getResponseId())).build();
        }, new ResourceContextBuilder().withGlobalAdminRights().build());
    }
}

