/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.user.Group;
import com.google.gson.Gson;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.PermissionValidator;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import eps.focuspro.rest.dtos.DropdownSetIdDto;
import eps.focuspro.rest.dtos.SpaceKeyDto;
import eps.focuspro.rest.dtos.SpaceSettingsDto;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/edm")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestDropdown {
    private final PermissionValidator permissionValidator;
    private final SetEntityAccessor setEntityAccessor;
    private final EdmSettingsManager edmSettingsManager;
    private final ResourcesRunner resourcesRunner;

    public RestDropdown(PermissionValidator permissionValidator, SetEntityAccessor setEntityAccessor, EdmSettingsManager edmSettingsManager, ResourcesRunner resourcesRunner) {
        this.permissionValidator = permissionValidator;
        this.setEntityAccessor = setEntityAccessor;
        this.edmSettingsManager = edmSettingsManager;
        this.resourcesRunner = resourcesRunner;
    }

    @POST
    @Path(value="/save/statusSpaceSettings")
    @ReadOnlyAccessAllowed
    public Response postSpaceSettings(SpaceSettingsDto input) {
        return this.resourcesRunner.run(() -> {
            List<String> groupList = this.getListFromJson(input.groupList);
            List<String> cssClasses = this.getListFromJson(input.cssClasses);
            EdmSpaceSettings edmSpaceSettings = new EdmSpaceSettings(input.spaceKey, cssClasses, groupList);
            this.edmSettingsManager.saveSpaceSettings(edmSpaceSettings);
            return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withPluginLicense().build());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/license/valid")
    @ReadOnlyAccessAllowed
    public Response getLicenseValidation() {
        return this.resourcesRunner.run(() -> Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build(), new ResourceContextBuilder().withGlobalAdminRights().withPluginLicense().build());
    }

    @AnonymousAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/css/classes")
    @ReadOnlyAccessAllowed
    public Response getCssClasses(SpaceKeyDto input) {
        return this.resourcesRunner.run(() -> {
            if (this.notAnonymousOrAllowed()) {
                EdmSpaceSettings edmSpaceSettings = this.edmSettingsManager.getSpaceSettings(input.spaceKey);
                List<String> configClasses = this.edmSettingsManager.getGlobalSettings().getCssClasses();
                List<String> spaceClasses = edmSpaceSettings.getCssClasses();
                ArrayList<String> completeClasses = new ArrayList<String>();
                completeClasses.addAll(configClasses);
                completeClasses.addAll(spaceClasses);
                completeClasses.add(" ");
                return Response.ok((Object)new Gson().toJson(completeClasses), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.getResponseForbiddenAnonymous();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/text/get-set-names")
    @ReadOnlyAccessAllowed
    public Response getDropdownKeys(SpaceKeyDto input) {
        return this.resourcesRunner.run(() -> {
            if (this.notAnonymousOrAllowed()) {
                List<DropdownSet<TextOption>> dropdownSets = this.setEntityAccessor.getTextSets(input.spaceKey);
                ArrayList valueMap = new ArrayList();
                for (DropdownSet<TextOption> dropdownSet : dropdownSets) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dropdownSet.getId());
                    map.put("name", dropdownSet.getName());
                    valueMap.add(map);
                }
                return Response.ok((Object)new Gson().toJson(valueMap), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.getResponseForbiddenAnonymous();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousAllowed
    @POST
    @Path(value="/status/get-set-names")
    @ReadOnlyAccessAllowed
    public Response getDropdownStatusKeys(SpaceKeyDto input) {
        return this.resourcesRunner.run(() -> {
            if (this.notAnonymousOrAllowed()) {
                List<DropdownSet<LozengeOption>> dropdownSets = this.setEntityAccessor.getLozengeSets(input.spaceKey);
                ArrayList valueMap = new ArrayList();
                for (DropdownSet<LozengeOption> dropdownSet : dropdownSets) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dropdownSet.getId());
                    map.put("name", dropdownSet.getName());
                    valueMap.add(map);
                }
                return Response.ok((Object)new Gson().toJson(valueMap), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.getResponseForbiddenAnonymous();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousAllowed
    @GET
    @Produces(value={"application/json"})
    @Path(value="/admin")
    @ReadOnlyAccessAllowed
    public Response isAdmin() {
        return this.resourcesRunner.run(() -> {
            if (!this.notAnonymousOrAllowed()) {
                return this.getResponseForbiddenAnonymous();
            }
            return Response.ok((Object)new Gson().toJson((Object)true), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withGlobalAdminRights().build());
    }

    @AnonymousAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/text/get-options-from-set")
    @ReadOnlyAccessAllowed
    public Response getDropdownValues(DropdownSetIdDto input) {
        return this.resourcesRunner.run(() -> {
            if (this.notAnonymousOrAllowed()) {
                DropdownSet<TextOption> dropdownSet = this.setEntityAccessor.getTextSet(input.setId);
                if (dropdownSet != null) {
                    return Response.ok((Object)new Gson().toJson(dropdownSet.getOptionsList()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
                }
                return Response.ok((Object)new Gson().toJson(new ArrayList()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.getResponseForbiddenAnonymous();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/status/get-options-from-set")
    @ReadOnlyAccessAllowed
    public Response getStatusDropdownOptions(DropdownSetIdDto input) {
        return this.resourcesRunner.run(() -> {
            if (this.notAnonymousOrAllowed()) {
                DropdownSet<LozengeOption> dropdownSet = this.setEntityAccessor.getLozengeSet(input.setId);
                if (dropdownSet == null) {
                    return Response.ok((Object)new Gson().toJson(new ArrayList())).build();
                }
                return Response.ok((Object)new Gson().toJson(dropdownSet.getOptionsList()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.getResponseForbiddenAnonymous();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousAllowed
    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups/allWritableNames")
    @ReadOnlyAccessBlocked
    public Response getAllWritableGroupNames() {
        return this.resourcesRunner.run(() -> {
            if (this.notAnonymousOrAllowed()) {
                List<Group> allWritableGroups = this.permissionValidator.getAllGroups();
                List<String> allWritableGroupNames = this.permissionValidator.getGroupNamesFromGroups(allWritableGroups);
                return Response.ok((Object)new Gson().toJson(allWritableGroupNames), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.getResponseForbiddenAnonymous();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousAllowed
    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups/allPermittedGroups")
    @ReadOnlyAccessAllowed
    public Response getAllPermittedGroupNames() {
        return this.resourcesRunner.run(() -> {
            if (this.notAnonymousOrAllowed()) {
                EdmGlobalSettings dbSettings = this.edmSettingsManager.getGlobalSettings();
                List<String> permittedGroups = dbSettings.getPermittedGroups();
                return Response.ok((Object)new Gson().toJson(permittedGroups), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.getResponseForbiddenAnonymous();
        }, new ResourceContextBuilder().build());
    }

    private List<String> getListFromJson(String json) {
        JSONArray jsonArray = new JSONArray(json);
        ArrayList<String> groupList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            groupList.add(jsonArray.getString(i));
        }
        return groupList;
    }

    private boolean notAnonymousOrAllowed() {
        return this.permissionValidator.isNotAnonymousOrAllowed(this.edmSettingsManager.getGlobalSettings().isAllowAnonymous());
    }

    private Response getResponseForbiddenAnonymous() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Anonymous users are not allowed to use the dropdown menu. This can be changed in the plugin configuration.").build();
    }
}

